﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_Rom.h>
#include <nn/fs/fs_RomForDebug.h>
#include <nn/fs/fs_SystemData.h>

#include "testFs_FsLib_Mount.h"

TEST_F(MountBasic, MountRom)
{
    size_t cacheBufferSize = 0;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountRomCacheSize(&cacheBufferSize));
    auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
    ASSERT_NE(nullptr, cacheBuffer);

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    NNT_ASSERT_RESULT_FAILURE(
        nn::fs::ResultPathNotFound,
        nn::fs::MountRom("rom", cacheBuffer.get(), cacheBufferSize));
#else
    NNT_ASSERT_RESULT_FAILURE(
        nn::fs::ResultPartitionNotFound,
        nn::fs::MountRom("rom", cacheBuffer.get(), cacheBufferSize));
#endif
}

TEST(CanMountRomForDebug, WithoutRom)
{
    EXPECT_TRUE(!nn::fs::CanMountRomForDebug());
}

TEST(Mount, MountSystemDataNotFound)
{
    const nn::ncm::SystemDataId Id = { 0x100000000000FFFF }; // 存在しないシステムデータ

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    NNT_EXPECT_RESULT_FAILURE(nn::fs::ResultNotImplemented, nn::fs::MountSystemData("systemData", Id)); // 現状未対応
#else
    NNT_EXPECT_RESULT_FAILURE(nn::fs::ResultTargetNotFound, nn::fs::MountSystemData("systemData", Id));
#endif
}

#if 0 // TODO: 自動化
TEST(Mount, MountSystemData)
{
    const nn::ncm::SystemDataId Ids[] =
    {
        { 0x1000000000002000 },
    };

    for( auto id : Ids )
    {
        NN_LOG("Mount system data <0x%16llx>.\n", id.value);
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSystemData("systemData", id));
        NNT_ASSERT_RESULT_SUCCESS(nnt::fs::util::DumpDirectoryRecursive("systemData:/"));
        nn::fs::Unmount("systemData");
    }
}
#endif

//
// NNT_FS_INSTANTIATE_TEST_CASE_MOUNT は
//
//   * testFs_FsLib_MountRom
//   * testFs_FsLib_MountData
//   * testFs_FsLib_MountRomOnFile
//
// でテストする
//
