﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_Bis.h>

class SetBisRootForHostHelper
{
public:
    SetBisRootForHostHelper(nn::fs::BisPartitionId bisPartitionId, const char* path) NN_NOEXCEPT
    {
        m_BisPartitionId = bisPartitionId;
#if defined(NN_BUILD_CONFIG_OS_WIN)
        nn::fs::SetBisRootForHost(m_BisPartitionId, path);
#endif
    }

    ~SetBisRootForHostHelper() NN_NOEXCEPT
    {
#if defined(NN_BUILD_CONFIG_OS_WIN)
        nn::fs::SetBisRootForHost(m_BisPartitionId, "");
#endif
    }

private:
    nn::fs::BisPartitionId m_BisPartitionId;
};
