﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/fs/fs_SdCardPrivate.h>
#include <nn/fs/fs_GameCard.h>

#include "testFs_FsLib_AccessLog.h"

TEST(MountSdCard, SuccessFailure)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
AccessLogTest: Generic
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::Unmount", name: "test" }
AccessLogTest: Generic-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::MountSdCard", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::Unmount", name: "test" }
*/
{
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSdCard(nnt::fs::MountName));
    ASSERT_TRUE(nn::fs::MountSdCard(nnt::fs::MountName).IsFailure());
    nn::fs::Unmount(nnt::fs::MountName);
}

TEST(MountGameCardPartition, DISABLED_Success)
{
    nn::fs::GameCardHandle handle;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::GetGameCardHandle(&handle));
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountGameCardPartition(nnt::fs::MountName, handle, nn::fs::GameCardPartition::Normal));
    nn::fs::Unmount(nnt::fs::MountName);
}

TEST(MountGameCardPartition, Failure)
/*
AccessLogTest: NX
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00172002, handle: 0x0000000000000000, priority: Normal, function: "MountGameCardPartition", name: "test", gamecard_handle: 0xFEDCBA09, gamecard_partition: Normal }
AccessLogTest: Generic
AccessLogTest: Generic-system
FS_ACCESS: { start: 0, end: 0, result: 0x00172002, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::MountGameCardPartition", name: "test", gamecard_handle: 0xFEDCBA09, gamecard_partition: Normal }
*/
{
    ASSERT_TRUE(nn::fs::MountGameCardPartition(nnt::fs::MountName, 0, nn::fs::GameCardPartition::Normal).IsFailure());
}
