﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfp.h>
#include <nn/nn_Log.h>
#include <nnt/nntest.h>

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)

namespace
{
static bool g_IsNfpInitialized = false;
}

TEST(Nfp, DISABLED_Success)
{}

TEST(Nfp, Failure)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Mount", name_space: nfp, model_type: 0, nfp_mount_target: 3 }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Mount", name_space: nfp, model_type: 0, nfp_mount_target: 1 }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "CreateApplicationArea", name_space: nfp, access_id: 0x00000000, data_size: 16 }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Flush", name_space: nfp }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Restore", name_space: nfp }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Mount", name_space: nfp, model_type: 0, nfp_mount_target: 3 }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Mount", name_space: nfp, model_type: 0, nfp_mount_target: 1 }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "CreateApplicationArea", name_space: nfp, access_id: 0x00000000, data_size: 16 }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Flush", name_space: nfp }
FS_ACCESS: { start: 0, end: 0, result: 0x00008073, handle: 0x0000000000000000, priority: Normal, function: "Restore", name_space: nfp }
*/
{
    if( !g_IsNfpInitialized )
    {
        nn::nfp::Initialize();
        g_IsNfpInitialized = true;
    }
    nn::nfp::DeviceHandle handle = {};
    ASSERT_TRUE(nn::nfp::Mount(handle, nn::nfp::ModelType_Amiibo).IsFailure());
    ASSERT_TRUE(nn::nfp::Mount(handle, nn::nfp::ModelType_Amiibo, nn::nfp::MountTarget_Rom).IsFailure());
    nn::nfp::ApplicationAreaCreateInfo info;
    char buffer[16];
    info.accessId = 0;
    info.initialDataSize = sizeof(buffer);
    info.pInitialData = buffer;
    ASSERT_TRUE(nn::nfp::CreateApplicationArea(handle, info).IsFailure());
    ASSERT_TRUE(nn::nfp::Flush(handle).IsFailure());
    ASSERT_TRUE(nn::nfp::Restore(handle).IsFailure());
}

#endif
