﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/fs/fs_AddOnContent.h>
#include <nn/fs/fs_AddOnContentPrivate.h>

#include "testFs_FsLib_AccessLog.h"

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)

TEST(MountAddOnContent, Success)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: -4095, size: 88 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: -4095 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: -4095, size: 88 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: -4095 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: -4095, size: 88 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: -4095 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: -4095, size: 88 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: -4095 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
*/
{
    int64_t AocIndex = -4095;
    {
        size_t cacheBufferSize = 0;
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountAddOnContentCacheSize(&cacheBufferSize, AocIndex));

        auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
        ASSERT_NE(nullptr, cacheBuffer);

        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountAddOnContent(nnt::fs::MountName, AocIndex, cacheBuffer.get(), cacheBufferSize));
        nn::fs::Unmount(nnt::fs::MountName);
    }
    {
        const nn::ApplicationId applicationId = { 0x0100000000003006 };
        size_t cacheBufferSize = 0;
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountAddOnContentCacheSize(&cacheBufferSize, applicationId, AocIndex));

        auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
        ASSERT_NE(nullptr, cacheBuffer);

        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountAddOnContent(nnt::fs::MountName, applicationId, AocIndex, cacheBuffer.get(), cacheBufferSize));
        nn::fs::Unmount(nnt::fs::MountName);
    }
}

TEST(MountAddOnContent, Failure)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: 0, size: 1024 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: 0 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: 0, size: 1024 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: 0 }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: 0, size: 1024 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: 0 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "QueryMountAddOnContentCacheSize", index: 0, size: 1024 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountAddOnContent", name: "test", index: 0 }
*/
{
    {
        size_t cacheBufferSize = 1024;
        ASSERT_TRUE(nn::fs::QueryMountAddOnContentCacheSize(&cacheBufferSize, 0).IsFailure());

        auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
        ASSERT_NE(nullptr, cacheBuffer);

        ASSERT_TRUE(nn::fs::MountAddOnContent(nnt::fs::MountName, 0, cacheBuffer.get(), cacheBufferSize).IsFailure());
    }
    {
        size_t cacheBufferSize = 1024;
        const nn::ApplicationId applicationId = { 1 };
        ASSERT_TRUE(nn::fs::QueryMountAddOnContentCacheSize(&cacheBufferSize, applicationId, 0).IsFailure());

        auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
        ASSERT_NE(nullptr, cacheBuffer);

        ASSERT_TRUE(nn::fs::MountAddOnContent(nnt::fs::MountName, applicationId, 0, cacheBuffer.get(), cacheBufferSize).IsFailure());
    }
}

#endif
