﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/diag/diag_Backtrace.h>
#include <nn/diag/diag_Module.h>

#include <nnt/fsUtil/testFs_util_function_stl.h>

namespace nnt { namespace fs { namespace util {

void DumpModules() NN_NOEXCEPT
{
    auto size = nn::diag::GetRequiredBufferSizeForGetAllModuleInfo();
    auto buffer = Vector<char>(size);
    if( buffer.data() == nullptr )
    {
        return;
    }

    NN_LOG("Modules:\n");

    nn::diag::ModuleInfo* pModuleInfo;
    auto moduleInfoCount = nn::diag::GetAllModuleInfo(&pModuleInfo, buffer.data(), size);
    for( decltype(moduleInfoCount) i = 0; i < moduleInfoCount; ++i )
    {
        const auto& moduleInfo = pModuleInfo[i];
#if defined(NN_BUILD_CONFIG_ADDRESS_32)
        NN_LOG("%08X-%08X %s\n", moduleInfo.baseAddress, moduleInfo.baseAddress + moduleInfo.size, moduleInfo.path);
#else
        NN_LOG("%016llX-%016llX %s\n", moduleInfo.baseAddress, moduleInfo.baseAddress + moduleInfo.size, moduleInfo.path);
#endif
    }
}

void DumpStackTrace() NN_NOEXCEPT
{
    static const int CountMax = 64;
    auto buffer = Vector<uintptr_t>(CountMax);
    if( buffer.data() == nullptr )
    {
        return;
    }

    NN_LOG("Stack Trace:\n");

    auto backTraceCount = nn::diag::GetBacktrace(buffer.data(), CountMax);
    for( decltype(backTraceCount) i = 0; i < backTraceCount; ++i )
    {
#if defined(NN_BUILD_CONFIG_ADDRESS_32)
        NN_LOG("%08X\n", buffer.data()[i]);
#else
        NN_LOG("%016llX\n", buffer.data()[i]);
#endif
    }
}

}}}
