﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define NN_ENABLE_HTC

#include <chrono>
#include <mutex>

#include <nn/crypto.h>
#include <nn/htc.h>
#include <nn/result/result_HandlingUtility.h>

#include <nnt/fsUtil/testFs_util.h>

#include <nn/os/os_Random.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/util/util_FormatString.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/fs/fs_GameCard.h>
#include <nn/fs/fs_IEventNotifier.h>

#include <nn/fs/fsa/fs_IFile.h>

#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_DeviceSaveData.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/fs/fs_SystemSaveDataPrivate.h>
#include <nn/fs/fs_SystemBcatSaveData.h>
#include <nn/fs/fs_BcatSaveData.h>
#include <nn/fs/fs_SaveData.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <nn/fs/fs_SdCardPrivate.h>

#include <nn/fssrv/fssrv_SaveDataIndexerManager.h>
#include <nn/fs/fs_SaveDataTransferType.h>

#include <nn/fs/fs_DebugPrivate.h>
#include "detail/fssrv_SaveDataTransferVersion2.h"

using namespace nn;
using namespace nn::fs;


void GenerateAesKeyForSaveDataTransfer(void* pBuffer, size_t bufferSize, nn::fssrv::SaveDataTransferCryptoConfiguration::KeyIndex keyIndex, const void* pKeySource, size_t keySourceSize) NN_NOEXCEPT;

// Generic 用ダミー
#if defined(NN_BUILD_CONFIG_OS_WIN)

namespace nn {

namespace spl {

void InitializeForCrypto() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

}

namespace fs {
namespace detail {

void GenerateAesKeyForSaveDataTransfer(void* pBuffer, size_t bufferSize, nn::fssrv::SaveDataTransferCryptoConfiguration::KeyIndex keyIndex, const void* pKeySource, size_t keySourceSize) NN_NOEXCEPT;

}
}

}

void GenerateAesKeyForSaveDataTransfer(void* pBuffer, size_t bufferSize, nn::fssrv::SaveDataTransferCryptoConfiguration::KeyIndex keyIndex, const void* pKeySource, size_t keySourceSize) NN_NOEXCEPT
{
    return nn::fs::detail::GenerateAesKeyForSaveDataTransfer(pBuffer, bufferSize, keyIndex, pKeySource, keySourceSize);
}

#endif


namespace nnt { namespace fs { namespace util {


nn::Result OverrideSaveDataTransferTokenSignVerificationKeyByTestKey()
{
    return nn::fs::OverrideSaveDataTransferTokenSignVerificationKey(TestPublicModulus, sizeof(TestPublicModulus));
}

void GenerateKeySeedPackage(
    nn::fs::SaveDataTransferManagerVersion2::KeySeedPackage* pOutKsp,
    const nn::ncm::ApplicationId applicationId,
    const nn::fs::detail::SdaId sdaId,
    const nn::fs::detail::KeySeed& keySeed,
    const nn::fs::detail::InitialDataMac initialDataMac,
    const nn::fs::SaveDataTransferManagerVersion2::Challenge& challenge,
    bool falsify) NN_NOEXCEPT
{
    auto pKsp = reinterpret_cast<nn::fssrv::detail::SaveDataTransferManagerVersion2::KeySeedPackage*>(pOutKsp);

    // version zero
    memset(pKsp, 0x00, sizeof(nn::fssrv::detail::SaveDataTransferManagerVersion2::KeySeedPackage));

    // content
    memcpy(pKsp->encryptedArea.signedArea.challenge,      challenge.data,       sizeof(pKsp->encryptedArea.signedArea.challenge));
    memcpy(pKsp->encryptedArea.signedArea.applicationId,  &applicationId.value, sizeof(pKsp->encryptedArea.signedArea.applicationId));
    memcpy(pKsp->encryptedArea.signedArea.sdaId,          sdaId.data,           sizeof(pKsp->encryptedArea.signedArea.sdaId));
    memcpy(pKsp->encryptedArea.signedArea.initialDataMac, initialDataMac.data,  sizeof(pKsp->encryptedArea.signedArea.initialDataMac));
    memcpy(pKsp->encryptedArea.signedArea.keySeed,        keySeed.data,         sizeof(pKsp->encryptedArea.signedArea.keySeed));

    // ksp iv
    nn::crypto::GenerateCryptographicallyRandomBytes(pKsp->kspIv, sizeof(pKsp->kspIv));

    // keySeed
    memcpy(pKsp->encryptedArea.signedArea.keySeed, keySeed.data, sizeof(pKsp->encryptedArea.signedArea.keySeed));

    char RsaSalt[nn::crypto::Sha256Generator::HashSize];
    nn::crypto::GenerateCryptographicallyRandomBytes(RsaSalt, sizeof(RsaSalt));

    // sign
    nn::crypto::SignRsa2048PssSha256(
        pKsp->encryptedArea.sign, sizeof(pKsp->encryptedArea.sign),
        TestPublicModulus, sizeof(TestPublicModulus),
        TestPrivateExponent, sizeof(TestPrivateExponent),
        &pKsp->encryptedArea.signedArea, sizeof(pKsp->encryptedArea.signedArea),
        RsaSalt, sizeof(RsaSalt));

    // 署名後の改竄
    if (falsify)
    {
        pKsp->encryptedArea.signedArea.reserverd2[0] ^= 0xFF;
    }

    // AES-GCM
    char key[16];
    ::GenerateAesKeyForSaveDataTransfer(key, 16, nn::fssrv::SaveDataTransferCryptoConfiguration::KeyIndex::CloudBackUpToken, nullptr, 0);
    auto encryptedSize = nn::crypto::EncryptAes128Gcm(
        &pKsp->encryptedArea, sizeof(pKsp->encryptedArea),
        &pKsp->kspMac, sizeof(pKsp->kspMac),
        key, sizeof(key),
        pKsp->kspIv, sizeof(pKsp->kspIv),
        &pKsp->encryptedArea, sizeof(pKsp->encryptedArea),
        nullptr, 0
    );

    EXPECT_EQ(sizeof(pKsp->encryptedArea), encryptedSize);
}


}}}
