﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsApiSaveDataExtraData/testFs_ApiSaveDataExtraData.h>

namespace nnt { namespace fs { namespace api {
    void LoadPostConditionSaveDataExtraDataTests() NN_NOEXCEPT
    {
        return;
    }

    class PostConditionExtraData : public GetSaveDataExtraDataTestFixture
    {
    };

    //!< @brief ExtraData を読み書きしたあと、Unmount した場合の挙動を確認する
    TEST_F(PostConditionExtraData, ReadWriteExtraData_Remount)
    {
        nn::fs::SaveDataExtraData data;

        {
            auto& extraDataAccessor = GetExtraDataAccessor();

            NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.ReadExtraData(&data));

            data.flags = 1;
            NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.WriteExtraData(data));
        }

        RemountFs();

        {
            auto& extraDataAccessor = GetExtraDataAccessor();

            if( GetFsAttribute()->isSaveFileSystem && !GetSaveDataExtraDataAttribute().isCommitSaveDataExtraDataWhenWrite )
            {
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.ReadExtraData(&data));
                ASSERT_EQ(0, data.flags);
            }
            else
            {
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.ReadExtraData(&data));
                ASSERT_EQ(1, data.flags);
            }
        }
    }

    //!< @brief ExtraData を読み書きしたあと、Commit/CommitExtraData した場合の挙動を確認する
    TEST_F(PostConditionExtraData, CommitExtraData)
    {
        auto& extraDataAccessor = GetExtraDataAccessor();

        std::function<void()> commitFunctions[] =
        {
            [=]() NN_NOEXCEPT
            {
                NNT_ASSERT_RESULT_SUCCESS(GetFs().Commit());
            },
            [&]() NN_NOEXCEPT
            {
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.CommitExtraData(true));
            },
        };

        for( auto commitFunction : commitFunctions )
        {
            // 読み書き
            {
                nn::fs::SaveDataExtraData extraData;
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.ReadExtraData(&extraData));
                extraData.flags = 0;
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.WriteExtraData(extraData));
            }

            // コミット
            commitFunction();

            // 読み書き
            {
                nn::fs::SaveDataExtraData extraData;
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.ReadExtraData(&extraData));
                extraData.flags = 1;
                NNT_ASSERT_RESULT_SUCCESS(extraDataAccessor.WriteExtraData(extraData));
            }

            if( GetStaticExtraDataReader() )
            {
                nn::fs::SaveDataExtraData extraData;
                GetStaticExtraDataReader()(&extraData, sizeof(extraData));

                if( GetSaveDataExtraDataAttribute().isCommitSaveDataExtraDataWhenWrite )
                {
                    // コミット前は反映されない
                    ASSERT_EQ(1, extraData.flags);

                    // コミット
                    commitFunction();

                    // コミット後には反映される
                    GetStaticExtraDataReader()(&extraData, sizeof(extraData));
                    ASSERT_EQ(1, extraData.flags);
                }
                else
                {
                    ASSERT_EQ(0, extraData.flags);
                }
            }
        }
    }

}}}
