﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nnt/nntest.h>
#include <nnt/fsApi/testFs_Api.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/result/testResult_Assert.h>

using namespace nn::fs;
using namespace nn::fs::fsa;
using namespace nnt::fs::util;

#if 0
namespace {
    const int FileSize = 32;

    typedef nn::Result(*ReadFunction)(nnt::fs::api::ITestFile* pTestFile, int64_t offset, void* buffer, size_t size);

    nn::Result ReadFunction0(nnt::fs::api::ITestFile* pTestFile, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT
    {
        NN_RESULT_DO(pTestFile->Read(offset, buffer, size, nn::fs::ReadOption()));
        NN_RESULT_SUCCESS;
    }

    nn::Result ReadFunction1(nnt::fs::api::ITestFile* pTestFile, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT
    {
        NN_RESULT_DO(pTestFile->Read(offset, buffer, size));
        NN_RESULT_SUCCESS;
    }

    nn::Result ReadFunction2(nnt::fs::api::ITestFile* pTestFile, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT
    {
        size_t sizeRead;
        NN_RESULT_DO(pTestFile->Read(&sizeRead, offset, buffer, size, nn::fs::ReadOption()));
        NN_RESULT_SUCCESS;
    }

    nn::Result ReadFunction3(nnt::fs::api::ITestFile* pTestFile, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT
    {
        size_t sizeRead;
        NN_RESULT_DO(pTestFile->Read(&sizeRead, offset, buffer, size));
        NN_RESULT_SUCCESS;
    }

    bool IsReadOverload(ReadFunction read) NN_NOEXCEPT
    {
        return read != ReadFunction2;
    }

    const ReadFunction ReadFunctions[] =
    {
        ReadFunction0,
        ReadFunction1,
        ReadFunction2,
        ReadFunction3
    };
}
#endif

namespace nnt { namespace fs { namespace api {
    void LoadPreConditionRoTests()
    {
        return;
    }

    class PreConditionRoInvalidOpenMode : public GetFileSystemTestFixture
    {
    protected:
        PreConditionRoInvalidOpenMode()
        {
            CheckGlobalNewDeleteFlagTestFixture::DisableCheck();
            CheckMemoryLeakFixture::DisableCheck();
        }

        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            GetFileSystemTestFixture::SetUp();
            m_FileName = GetTestRootPath().append("/PreConditionRo/test.file");
            m_NewFileName = GetTestRootPath().append("/PreConditionRo/newtest.file");
            m_DirectoryName = GetTestRootPath().append("/PreConditionRo/dir");
        }
        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
        {
            GetFileSystemTestFixture::TearDown();
        }

        const String& GetFileName() NN_NOEXCEPT
        {
            return m_FileName;
        }

        const String& GetNewFileName() NN_NOEXCEPT
        {
            return m_NewFileName;
        }

        const String& GetDirectoryName() NN_NOEXCEPT
        {
            return m_DirectoryName;
        }

    private:
        String m_FileName;
        String m_NewFileName;
        String m_DirectoryName;
    };

    class PreConditionRoInvalidArgument : public PreConditionRoInvalidOpenMode
    {
    };

    //! @brief 不正なモードでファイルを開くと失敗する
    TEST_F(PreConditionRoInvalidOpenMode, OpenFile)
    {
        std::unique_ptr<ITestFile> file;
        NNT_EXPECT_RESULT_FAILURE(
            ResultInvalidArgument,
            GetFs().OpenFile(&file, GetFileName().c_str(), OpenMode_AllowAppend)
        );
        NNT_EXPECT_RESULT_FAILURE(
            ResultInvalidArgument,
            GetFs().OpenFile(&file, GetFileName().c_str(), static_cast<OpenMode>(0))
        );
        NNT_EXPECT_RESULT_FAILURE(
            ResultInvalidArgument,
            GetFs().OpenFile(&file, GetFileName().c_str(), static_cast<OpenMode>(15))
        );
    }
#if 0
    TEST_P(PreConditionRoInvalidOpenMode, ReadFile)
    {
        auto read = GetParam();
        NNT_FS_UTIL_SKIP_TEST_UNLESS(!IsReadOverload(read) || GetFsAttribute()->isReadOverloadsSupported);

        std::unique_ptr<ITestFile> file;
        char buffer[FileSize + 1] = { 0 };

        NNT_EXPECT_RESULT_SUCCESS(
            GetFs().OpenFile(
                &file,
                GetFileName().c_str(),
                static_cast<OpenMode>(OpenMode_Write | OpenMode_AllowAppend)
            )
        );
        NNT_EXPECT_RESULT_FAILURE(
            ResultInvalidOperationForOpenMode,
            read(file.get(), 0, buffer, FileSize)
        );
    }

    INSTANTIATE_TEST_CASE_P(WithReadOverloads,
        PreConditionRoInvalidOpenMode,
        ::testing::ValuesIn(ReadFunctions));
#endif

    //! @brief CreateFile で不正な引数なら失敗する
    TEST_F(PreConditionRoInvalidArgument, CreateFile)
    {
        NNT_EXPECT_RESULT_FAILURE(
            ResultOutOfRange,
            GetFs().CreateFile(GetNewFileName().c_str(), -1)
        );
    }

    //! @brief WriteFile で不正な引数なら失敗する
    TEST_F(PreConditionRoInvalidArgument, WriteFile)
    {
        // ITestFile のテストをするためにファイルを開く
        std::unique_ptr<ITestFile> file;
        NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenFile(&file, GetFileName().c_str(), OpenMode_Read));

        static const size_t BufSize = 256;
        char buf[BufSize] = {};
        WriteOption writeOption = {};
        NNT_EXPECT_RESULT_FAILURE(
            ResultOutOfRange,
            file->Write(-1, buf, BufSize, writeOption)
        );
    }

    //! @brief SetSize で不正な引数なら失敗する
    TEST_F(PreConditionRoInvalidArgument, SetSize)
    {
        // ITestFile のテストをするためにファイルを開く
        std::unique_ptr<ITestFile> file;
        NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenFile(&file, GetFileName().c_str(), OpenMode_Read));

        NNT_EXPECT_RESULT_FAILURE(ResultOutOfRange, file->SetSize(-1));
    }

    //! @brief OpenDirectory で不正な OpenDirectoryMode なら失敗する
    TEST_F(PreConditionRoInvalidArgument, OpenDirectory)
    {
        std::unique_ptr<ITestDirectory> directory;
        NNT_EXPECT_RESULT_FAILURE(
            ResultInvalidArgument,
            GetFs().OpenDirectory(&directory, GetDirectoryName().c_str(), static_cast<OpenDirectoryMode>(0))
        );
        NNT_EXPECT_RESULT_FAILURE(
            ResultInvalidArgument,
            GetFs().OpenDirectory(&directory, GetDirectoryName().c_str(), static_cast<OpenDirectoryMode>(15))
        );
    }

    //! @brief ReadDirectory で不正な引数なら失敗する
    TEST_F(PreConditionRoInvalidArgument, ReadDirectory)
    {
        const OpenDirectoryMode openDirectoryModes[] =
        {
            OpenDirectoryMode_Directory,
            OpenDirectoryMode_File,
            OpenDirectoryMode_All
        };
        for( auto openDirecotryMode : openDirectoryModes )
        {
            // ITestDirectory のテストをするためにディレクトリを開く
            std::unique_ptr<ITestDirectory> directory;
            NNT_ASSERT_RESULT_SUCCESS(
                GetFs().OpenDirectory(&directory, GetDirectoryName().c_str(), openDirecotryMode)
            );

            // ITestDirectory::Read
            int64_t readCount = 0;
            DirectoryEntry entry = {};
            NNT_EXPECT_RESULT_FAILURE(
                ResultInvalidArgument,
                directory->Read(&readCount, &entry, -1)
            );
        }
    }
}}}
