﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsApi/testFs_Api.h>

using namespace nn::fs;
using namespace nn::fs::fsa;
using namespace nnt::fs::util;

namespace nnt { namespace fs { namespace api {
    void LoadGetFreeSpaceSizeTests() NN_NOEXCEPT
    {
        return;
    }

    typedef CleanupFileSystemTestFixture GetFreeSpaceSizeCaller;

    TEST_F(GetFreeSpaceSizeCaller, GetFreeSpaceSize_GetTotalSpaceSize)
    {
        NNT_FS_UTIL_SKIP_TEST_UNLESS(GetFsAttribute()->isSupportedGetFreeSpaceSize);

        String fileName = GetTestRootPath().append("/");
        int64_t freeBytes = -1;
        int64_t totalBytes = -1;

        NNT_EXPECT_RESULT_SUCCESS(GetFs().GetFreeSpaceSize(&freeBytes, fileName.c_str()));
        NNT_EXPECT_RESULT_SUCCESS(GetFs().GetTotalSpaceSize(&totalBytes, fileName.c_str()));

        EXPECT_LE(0, freeBytes);
        EXPECT_LT(0, totalBytes);
        EXPECT_GE(totalBytes, freeBytes);

        NN_LOG("%s space size : %lld / %lld Bytes\n",  fileName.c_str(), freeBytes, totalBytes);
    }
}}}
