﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsApi/testFs_Api.h>

namespace nnt { namespace fs { namespace api {
    void LoadDirectoryTests() NN_NOEXCEPT
    {
        return;
    }

    typedef CleanupFileSystemTestFixture DirectoryTest;

    //! @brief CleanDirectoryRecursively() が正しく動作していること
    TEST_F(DirectoryTest, Clean)
    {
        std::mt19937 rng(nnt::fs::util::GetRandomSeed());

        for( auto count = 0; count < 5; ++count )
        {
            nnt::fs::util::Vector<nnt::fs::util::String> directoryPaths(1, GetTestRootPath());

            // テストルートディレクトリ内に無作為な構成でエントリを作成する
            for( auto entryCount = 0; entryCount < 10; ++entryCount )
            {
                const auto parentIndex
                    = std::uniform_int_distribution<size_t>(0, directoryPaths.size() - 1)(rng);
                auto entryPath = directoryPaths[parentIndex];
                {
                    char buffer[8] = {};
                    nn::util::SNPrintf(buffer, sizeof(buffer), "/%d_%d", count, entryCount);
                    entryPath += buffer;
                }

                if( std::uniform_int_distribution<size_t>(0, 1)(rng) != 0 )
                {
                    NNT_EXPECT_RESULT_SUCCESS(GetFs().CreateFile(entryPath.c_str(), count));
                }
                else
                {
                    nn::Result result = GetFs().CreateDirectory(entryPath.c_str());
                    NNT_EXPECT_RESULT_SUCCESS(result);
                    if( result.IsSuccess() )
                    {
                        directoryPaths.emplace_back(std::move(entryPath));
                    }
                }
            }

            // CleanDirectoryRecursively() によりテストルートディレクトリが空になることを確認する
            NNT_EXPECT_RESULT_SUCCESS(GetFs().CleanDirectoryRecursively(GetTestRootPath().c_str()));

           std::unique_ptr<ITestDirectory> directory;
            int64_t entryCount = 0;
            NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenDirectory(
                &directory,
                GetTestRootPath().c_str(),
                nn::fs::OpenDirectoryMode_All));
            NNT_EXPECT_RESULT_SUCCESS(directory->GetEntryCount(&entryCount));
            EXPECT_EQ(0, entryCount);
        }
    }

}}}
