﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testFriends_Common.h"

// 2 つの NA をリンクする必要がある。
//
// 0: 3DS フレンドリスト取得 API を実行する
//    → テスト用アカウント（https://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=174256161）
// 1: NNID フレンドリスト取得 API を実行する
//    → テスト用アカウント（https://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=174256161）

namespace
{
    nn::account::Uid s_Users[nn::account::UserCountMax] = {};
    nn::account::NetworkServiceAccountId s_AccountIds[nn::account::UserCountMax] = {};
    int s_UserCount = 0;
}

class FriendsNintendoNetworkId : public testing::Test
{
protected:
    static void SetUpTestCase() NN_NOEXCEPT
    {
        nn::account::Initialize();
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::Initialize());

        nnt::friends::LoadAccounts(&s_UserCount, s_Users, s_AccountIds, NN_ARRAY_SIZE(s_Users));
        NN_ABORT_UNLESS_GREATER_EQUAL(s_UserCount, 2);

        nn::friends::SetOption(nn::friends::OptionAdmin_CheckUserStatus, 0);
    }

    static void TearDownTestCase() NN_NOEXCEPT
    {
    }
};

TEST_F(FriendsNintendoNetworkId, Get3DsFriendList)
{
    ASSERT_NO_FATAL_FAILURE(nnt::friends::ConnectNetwork());

    nn::friends::NintendoNetworkIdUserInfo userInfo = {};

    static nn::friends::NintendoNetworkIdFriend s_Friends[100];
    int count;

    nn::friends::AsyncContext context;
    NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNintendoNetworkIdInfo(&context, &userInfo, &count,
        s_Friends, s_Users[0], NN_ARRAY_SIZE(s_Friends), nn::friends::NintendoNetworkIdAccountType_3Ds));

    nn::os::SystemEvent completionEvent;
    NNT_ASSERT_RESULT_SUCCESS(context.GetSystemEvent(&completionEvent));

    completionEvent.Wait();

    NNT_ASSERT_RESULT_SUCCESS(context.GetResult());

    nnt::friends::Dump(userInfo, s_Friends, count);
}

TEST_F(FriendsNintendoNetworkId, GetNnidFriendList)
{
    ASSERT_NO_FATAL_FAILURE(nnt::friends::ConnectNetwork());

    nn::friends::NintendoNetworkIdUserInfo userInfo = {};

    static nn::friends::NintendoNetworkIdFriend s_Friends[100];
    int count;

    nn::friends::AsyncContext context;
    NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNintendoNetworkIdInfo(&context, &userInfo, &count,
        s_Friends, s_Users[1], NN_ARRAY_SIZE(s_Friends), nn::friends::NintendoNetworkIdAccountType_Nnid));

    nn::os::SystemEvent completionEvent;
    NNT_ASSERT_RESULT_SUCCESS(context.GetSystemEvent(&completionEvent));

    completionEvent.Wait();

    NNT_ASSERT_RESULT_SUCCESS(context.GetResult());

    nnt::friends::Dump(userInfo, s_Friends, count);
}
