﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testFriends_Common.h"

#include <nn/friends/detail/friends_PresenceAccessor.h>

TEST(FriendsPresenceAccessor, Empty)
{
    char buffer[nn::friends::PresenceAppFieldSize] = {};

    EXPECT_FALSE(nn::friends::detail::PresenceAccessor::SearchKey("a", buffer, sizeof (buffer)));
}

TEST(FriendsPresenceAccessor, Max1)
{
    // 仕様上 1 つのキーにつき、最小 3 バイト (キー 1 文字、終端文字、バリュー 0 文字、終端文字)
    char buffer[3 * 26] = {};

    for (int i = 0; i < 26; i++)
    {
        char key[2] = {static_cast<char>('a' + i)};

        NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue(key, "", buffer, sizeof (buffer)));
    }

    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultOutOfResource,
        nn::friends::detail::PresenceAccessor::AddKeyValue("1", "1", buffer, sizeof (buffer)));

    for (int i = 0; i < 26; i++)
    {
        char key[2] = {static_cast<char>('a' + i)};

        EXPECT_STREQ(nn::friends::detail::PresenceAccessor::SearchKey(key, buffer, sizeof (buffer)), "");
    }

    nn::friends::detail::PresenceAccessor::KeyValue kvs[30] = {};
    int count;

    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::GetKeyValueList(&count, kvs, 30, buffer, sizeof (buffer)));
    EXPECT_EQ(count, 26);

    // null 終端でないようにして正しく動作するかどうかの検証。
    buffer[sizeof (buffer) - 1] = '@';
    EXPECT_EQ(nn::friends::detail::PresenceAccessor::SearchKey("123456789012345678901234567890", buffer, sizeof (buffer)), nullptr);
}

TEST(FriendsPresenceAccessor, Max2)
{
    char buffer[3] = {};

    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultOutOfResource,
        nn::friends::detail::PresenceAccessor::AddKeyValue("12", "", buffer, sizeof (buffer)));
}

TEST(FriendsPresenceAccessor, Add1)
{
    char buffer[nn::friends::PresenceAppFieldSize] = {};

    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("a", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("b", "111", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("c", "222", buffer, sizeof (buffer)));

    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultDuplicatedKey,
        nn::friends::detail::PresenceAccessor::AddKeyValue("c", "2222", buffer, sizeof (buffer)));

    EXPECT_STREQ(nn::friends::detail::PresenceAccessor::SearchKey("a", buffer, sizeof (buffer)), "");
    EXPECT_STREQ(nn::friends::detail::PresenceAccessor::SearchKey("b", buffer, sizeof (buffer)), "111");
    EXPECT_STREQ(nn::friends::detail::PresenceAccessor::SearchKey("c", buffer, sizeof (buffer)), "222");

    EXPECT_EQ(nn::friends::detail::PresenceAccessor::SearchKey("d", buffer, sizeof (buffer)), nullptr);
}

TEST(FriendsPresenceAccessor, Add2)
{
    char buffer[nn::friends::PresenceAppFieldSize] = {};

    // 大文字小文字は区別しない
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("a", "111", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("A", "222", buffer, sizeof (buffer)));

    nn::friends::detail::PresenceAccessor::KeyValue kvs[2] = {};
    int count;

    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::GetKeyValueList(&count, kvs, 2, buffer, sizeof (buffer)));
    EXPECT_EQ(count, 2);

    EXPECT_STREQ(kvs[0].key, "a");
    EXPECT_STREQ(kvs[0].value, "111");
    EXPECT_STREQ(kvs[1].key, "A");
    EXPECT_STREQ(kvs[1].value, "222");
}

TEST(FriendsPresenceAccessor, Verify)
{
    char buffer[nn::friends::PresenceAppFieldSize] = {};

    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("1", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("a", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("A", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::PresenceAccessor::AddKeyValue("_", "", buffer, sizeof (buffer)));

    char invalidValue[] = {'\xFF', '\0'};

    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultInvalidArgument,
        nn::friends::detail::PresenceAccessor::AddKeyValue("A", invalidValue, buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultInvalidArgument,
        nn::friends::detail::PresenceAccessor::AddKeyValue("#", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultInvalidArgument,
        nn::friends::detail::PresenceAccessor::AddKeyValue("!", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultInvalidArgument,
        nn::friends::detail::PresenceAccessor::AddKeyValue(".", "", buffer, sizeof (buffer)));
    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultInvalidArgument,
        nn::friends::detail::PresenceAccessor::AddKeyValue(":", "", buffer, sizeof (buffer)));
}
