﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/os.h>
#include <nn/fgm.h>
#include <nn/nn_Log.h>
#include <nnt/nntest.h>

TEST(Fgm, RequestLimitTest)
{
    nn::Result result;
    int count = 0;
    bool hasFailed = false;
    while (!hasFailed)
    {
        nn::fgm::Request* request = new nn::fgm::Request;
        result = request->Initialize(nn::fgm::Module_Test, nn::fgm::Priority_Default);
        hasFailed = result.IsFailure();
        if (result.IsFailure())
            NN_LOG("Failed to initialize request %d:%d\n", result.GetModule(), result.GetDescription());
        else
            count++;
    }
    NN_LOG("Initialized %d requests before failure\n", count);
}
