﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/os.h>
#include <nn/fgm.h>
#include <nn/nn_Log.h>
#include <nnt/nntest.h>

TEST(FgmPermissionsTest, Permissions)
{
    nn::Result result;
    nn::fgm::Request request;

    for (int i = 0; i < nn::fgm::NumberOfPriorities; ++i)
    {
        if (i != nn::fgm::Priority_Default)
        {
            nn::fgm::Priority invalidPriority = static_cast<nn::fgm::Priority>(i);
            EXPECT_FALSE((result = request.Initialize(nn::fgm::Module_Test, invalidPriority)).IsSuccess());
            NN_LOG("Expected: Failed to Initialize request, error %d:%d\n",
                result.GetModule(), result.GetDescription());
        }
    }
}
