﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


/*
 * TODO: this test uses a personalized ticket (0xc9) and require some
 * manual changes to get it to work on Linux or ETD
 */
#include <nnt/nntest.h>
#include <nn/nn_Log.h>

#include <nn/escore/escore.h>
#include <nnt/escoreUtil/testEscore_util_istorage.h>

#include <nn/escorei/esitypes.h>

USING_ESCORE_UTIL_NAMESPACE
USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE
//#include <esitypes.h>
#include <nn/ioscrypto/iosctypes.h>

#include "../Common/testEs_Est_utils.h"

/* TODO: dynamically generate the following files */
#include "../Common/testEs_Ca_cert_new.cpp"
#include "../Common/testEs_Cp_cert_new.cpp"
#include "../Common/testEs_Xs_cert_new.cpp"

#include "../Common/testEs_Tkt6.cpp"
#include "../Common/testEs_Tkt7.cpp"

#include "../Common/testEs_Data4_enc.cpp"
#include "../Common/testEs_Data4_dec.cpp"


#if !defined( ES_TEST_READ_ONLY )
/* Hardcoded test info */
const u64 ES_TEST_TITLE_ID = 0x5000007700000099ULL;
const u32 ES_TEST_CONTENT_ID = 0xbabecafe;
#endif

/* Certificates */
const int ES_TEST_CERT_CHAIN_LEN = 3; /* CA, XS, CP */

static const void *__certs[ES_TEST_CERT_CHAIN_LEN + 2] = {caNewCert, xsNewCert, cpNewCert, NULL, NULL};
static u32 __nCerts = ES_TEST_CERT_CHAIN_LEN;


#if !defined( ES_TEST_READ_ONLY )
static u8 __inBuf[1024] ATTR_SHA256_ALIGN;
static u8 __outBuf[1024] ATTR_SHA256_ALIGN;
static u8 __outTicketBuf[2048];
static u8 __outTicketBuf2[2048];
#endif

static ESError __testSetup()
{
    return ES_ERR_OK;
}


static ESError __testCheckTicket()
{
    ESError rv = ES_ERR_OK;

    MemoryInputStream ticketStream( tkt6, sizeof( tkt6 ) );
    ETicket ticket;

    ESTitleKeyType outTitleKeyType;
    ESTitleKey outTitleKey;
    ESTicketId outTicketId;
    ESTicketVersion outTicketVersion;
    ESRightsId outRightsId;
    ESDeviceId outDeviceId;
    ESAccountId outAccountId;
    ESLicenseType outLicenseType;
    u32 outSize;
    bool outPreFlag;
    ESRightsId expectedRightsId = { 0x01,0x00,0x00,0x00,0x00,0x00,0x30,0x09,0};
    ESTitleKey expectedTitleKey;
    memset( &expectedTitleKey, 0, sizeof( ESTitleKey ) );
    ESAesKey expectedAesKey = { 0xd8,0x73,0x44,0x5c,0x73,0xd6,0x3e,0x21,
                                0xd0,0x53,0xb5,0xe3,0xce,0x6a,0xdf,0x39 };
    memcpy( &expectedTitleKey, expectedAesKey, sizeof( ESAesKey) );

    /* Don't verify since it's not yet de-personalized */
    rv = ticket.Set( ticketStream, __certs, __nCerts, false );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetSize( &outSize );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get size, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetTitleKeyType( &outTitleKeyType );
    if ( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get title key type, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetTitleKey( &outTitleKey );
    if ( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get title key, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetTicketId( &outTicketId );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get ticket id, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetTicketVersion( &outTicketVersion );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get ticket version, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetRightsId( &outRightsId );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get title id, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetDeviceId( &outDeviceId );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get device id, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetAccountId( &outAccountId );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get account id, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetPreInstallationFlag( &outPreFlag );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get pre-installation flag, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.GetLicenseType( &outLicenseType );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get license type, rv=%d\n", rv );
    }

    if( outSize != sizeof(ESV2Ticket) || outTitleKeyType != ES_TITLE_KEY_TYPE_AES ||
        memcmp( &outTitleKey, &expectedTitleKey, sizeof( ESTitleKey )) ||
        outTicketId != 0xF000004100000042UL || outTicketVersion != 0 ||
        memcmp(outRightsId, expectedRightsId, sizeof(ESRightsId))  ||
        outDeviceId != 0x0 || outAccountId != 0x0 || outPreFlag != false || outLicenseType != ES_LICENSE_PERMANENT)
    {
        ES_TEST_LOG( "Failed to verify ticket fields\n" );
        rv = ES_ERR_FAIL;
        goto end;
    }

    ES_TEST_LOG( "Passed ticket check\n" );

end:
    return rv;
}


#if !defined( ES_TEST_READ_ONLY )
static ESError __testCommonKey()
{
    ESError rv = ES_ERR_OK;

    ETicketService es;
    ETicket ticket;
    MemoryInputStream tmdStream( tmd5, sizeof( tmd5 ) );

    {
        MemoryInputStream ticketStream( tkt6, sizeof( tkt6 ) );
        MemoryOutputStream outTicketStream( __outTicketBuf, sizeof( __outTicketBuf ) );

        rv = es.ImportTicket( ticketStream, __certs, __nCerts, outTicketStream );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to import ticket, rv=%d\n", rv );
            goto end;
        }
    }

    {
        MemoryInputStream ticketStream( __outTicketBuf, sizeof( __outTicketBuf ) );

        rv = ticket.Set( ticketStream, __certs, __nCerts, true );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
            goto end;
        }

        rv = es.ImportTitleInit( ES_TEST_TITLE_ID, ticketStream, tmdStream, __certs, __nCerts );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to initialize title import, rv=%d\n", rv );
            goto end;
        }

        rv = es.ImportContentBegin( ES_TEST_CONTENT_ID, tmdStream, __certs, __nCerts );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to begin content import, rv=%d\n", rv );
            goto end;
        }

        rv = es.ImportContentData( data4_enc, sizeof( data4_enc ), __outBuf );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to import content data, rv=%d\n", rv );
            goto end;
        }

        rv = es.ImportContentEnd();
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to verify content data, rv=%d\n", rv );
            goto end;
        }

        rv = es.ImportTitleDone();
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to complete title import, rv=%d\n", rv );
            goto end;
        }

        if( memcmp( __outBuf, data4_dec, sizeof( data4_dec ) ) )
        {
            ES_TEST_LOG( "Failed data comparison\n" );
            rv = ES_ERR_FAIL;
            goto end;
        }
    }

    {
        MemoryInputStream ticketStream( __outTicketBuf, sizeof( __outTicketBuf ) );

        rv = es.ExportTitleInit( ES_TEST_TITLE_ID, ticketStream, tmdStream, __certs, __nCerts );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to initialize title export, rv=%d\n", rv );
            goto end;
        }

        rv = es.ExportContentBegin( ES_TEST_CONTENT_ID, tmdStream, __certs, __nCerts );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to begin content export, rv=%d\n", rv );
            goto end;
        }

        memcpy( __inBuf, data4_dec, sizeof( data4_dec ) );
        rv = es.ExportContentData( __inBuf, sizeof( data4_enc ), __outBuf );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to export content data, rv=%d\n", rv );
            goto end;
        }

        rv = es.ExportContentEnd();
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to verify content data, rv=%d\n", rv );
            goto end;
        }

        rv = es.ExportTitleDone();
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to complete title export, rv=%d\n", rv );
            goto end;
        }

        /* Note that the last block may be different */
        if( memcmp( __outBuf, data4_enc, sizeof( data4_enc ) - 16 ) )
        {
            ES_TEST_LOG( "Failed data comparison\n" );
            rv = ES_ERR_FAIL;
            goto end;
        }
    }

    {
        MemoryInputStream ticketStream( __outTicketBuf, sizeof( __outTicketBuf ) );
        MemoryOutputStream outTicketStream( __outTicketBuf2, sizeof( __outTicketBuf2 ) );

        rv = es.ExportTicket( ticketStream, __certs, __nCerts, outTicketStream );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to export ticket, rv=%d\n", rv );
            goto end;
        }
    }

    if( memcmp( tkt6, __outTicketBuf2, sizeof( tkt6 ) ) )
    {
        ES_TEST_LOG( "Failed ticket export check\n" );
        rv = ES_ERR_FAIL;
        goto end;
    }

    ES_TEST_LOG( "Imported/exported content with common key 1\n" );

end:
    return rv;
}  // NOLINT(impl/function_size)


static ESError __testNewCertChains()
{
    ESError rv = ES_ERR_OK;

    ETicketService es;
    ETicket ticket;
    MemoryInputStream ticketStream( tkt7, sizeof( tkt7 ) );
    MemoryInputStream ticketStream2( tkt3_dp, sizeof( tkt3_dp ) );
    MemoryInputStream tmdStream( tmd7, sizeof( tmd7 ) );
    MemoryInputStream tmdStream2( tmd5, sizeof( tmd5 ) );

    const void *ticketChain1[] = {caNewCert, xsNewCert, caCert, xsCert};
    const void *ticketChain2[] = {caCert, xsCert, caNewCert, xsNewCert};
    const void *ticketChain3[] = {caNewCert, xsNewCert};
    const void *ticketChain4[] = {caCert, xsCert};

    const void *tmdChain1[] = {caNewCert, cpNewCert, caCert, cpCert};
    const void *tmdChain2[] = {caCert, cpCert, caNewCert, cpNewCert};
    const void *tmdChain3[] = {caNewCert, cpNewCert};
    const void *tmdChain4[] = {caCert, cpCert};

    const void **chain;
    u32 i, chainSize;

    /* Try verifying a ticket using various cert chain permutations */
    for( i = 0; i < 3; i++ )
    {
        if( i == 1 )
        {
            chain = ticketChain1;
            chainSize = 4;
        }
        else if( i == 2 )
        {
            chain = ticketChain2;
            chainSize = 4;
        }
        else
        {
            chain = ticketChain3;
            chainSize = 2;
        }

        rv = ticket.Set( ticketStream, chain, chainSize, true );
        if( rv != ES_ERR_OK )
        {
            ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
            goto end;
        }
    }

    rv = ticket.Set( ticketStream, ticketChain4, 2, true );
    if( rv != ES_ERR_ISSUER_NOT_FOUND )
    {
        ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
        goto end;
    }

    /* Try switching certs in the cert cache */
    rv = ticket.Set( ticketStream2, ticketChain4, 2, true );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.Set( ticketStream, ticketChain3, 2, true );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
        goto end;
    }

    rv = ticket.Set( ticketStream2, ticketChain4, 2, true );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
        goto end;
    }

    /* Try verifying a TMD using various cert chain permutations */
    for( i = 0; i < 3; i++ )
    {
        if( i == 1 )
        {
            chain = tmdChain1;
            chainSize = 4;
        }
        else if( i == 2 )
        {
            chain = tmdChain2;
            chainSize = 4;
        }
        else
        {
            chain = tmdChain3;
            chainSize = 2;
        }
    }

    ES_TEST_LOG( "Verified the new cert chains\n" );

end:
    return rv;
}  // NOLINT (readability/fn_size)
#endif


static ESError __testCleanup()
{
    return ES_ERR_OK;
}


TEST( MiscTest, Misc )
{
    ESError rv = ES_ERR_OK;

    rv = __testSetup();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    rv = __testCheckTicket();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

#if !defined( ES_TEST_READ_ONLY )
    rv = __testCommonKey();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    rv = __testNewCertChains();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }
#endif

    rv = __testCleanup();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

end:
    if( rv == ES_ERR_OK )
    {
        ES_TEST_LOG( "***** Passed misc tests *****\n" );
    }

    return;
}
