﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <nnt/nntest.h>
#include <nn/util/util_FormatString.h>

#include "testEs_Testutils.h"
#include <nn/ioslibc/ioslibc.h>

const int TUL_MAX_STRING = 128;

static u32 __tulPass = 0;
static u32 __tulFail = 0;

static void __tul_Printv( const char *tname, const char *msg, const char *fmt, va_list ap )
{
    char lbuf[TUL_MAX_STRING];
    int len;

    len = nn::util::VSNPrintf( lbuf, sizeof lbuf, fmt, ap );
    if( len >= sizeof lbuf - 1 )
    {
        lbuf[sizeof lbuf - 1] = '\0';
    }
    TUL_PRINTF( "*** %s %s %s\n", tname, msg, lbuf );
}

void TUL_LogPrint( const char *tname, const char *fmt, ... )
{
    va_list ap;

    va_start( ap, fmt );
    __tul_Printv( tname, "LOG", fmt, ap );
    va_end( ap );
}

void TUL_Exit( const char *tname )
{
    if( __tulFail != 0 )
    {
        TUL_PRINTF( "*** %s FAILED = %d fail **\n", tname, __tulFail );
    }
    else if( __tulPass != 0 )
    {
        TUL_PRINTF( "*** %s PASSED = %d pass **\n", tname, __tulPass );
    }
    TUL_PRINTF( "*** TEST FINISHED %s => %d pass, %d fail **\n", tname, __tulPass, __tulFail );
    TUL_EXIT( __tulFail );
}

void TUL_LogFail( const char *tname, const char *fmt, ... )
{
    va_list ap;

    va_start( ap, fmt );
    __tul_Printv( tname, "TEST FAILED", fmt, ap );
    va_end( ap );
    __tulFail++;
}

void TUL_LogPass( const char *tname, const char *fmt, ... )
{
    va_list ap;

    va_start( ap, fmt );
    __tul_Printv( tname, "TEST PASSED", fmt, ap );
    va_end( ap );
    __tulPass++;
}
