﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *  Copyright 2011 iGware, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of iGware, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of iGware, Inc.
 */
#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/fs.h>

#include <nn/escore/escore.h>
#include <nnt/escoreUtil/testEscore_util_istorage.h>

USING_ESCORE_UTIL_NAMESPACE
USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE

#include "../Common/testEs_Est_utils.h"

/* TODO: dynamically generate the following files */
#include "../Common/testEs_Ca_cert_new.cpp"
#include "../Common/testEs_Cp_cert_new.cpp"
#include "../Common/testEs_Xs_cert_new.cpp"

#if !defined( ES_TEST_MEMORY_CONSTRAINT )
#include "../Common/testEs_Tkt2.cpp"
#endif

static const void *__certs[] = {caNewCert, xsNewCert, cpNewCert};
static const u32 __nCerts = sizeof( __certs ) / sizeof( __certs[0] );

#define CHECK_GOOD( result )                                           \
    do                                                                 \
    {                                                                  \
        if( result.IsFailure() )                                       \
        {                                                              \
            ES_TEST_LOG( "FAIL:  Bad result at line %d\n", __LINE__ ); \
            if( rv == ES_ERR_OK )                                      \
            {                                                          \
                rv = ES_ERR_INVALID;                                   \
            }                                                          \
            goto end;                                                  \
        }                                                              \
    } while( 0 )


static ESError __testSetup()
{
    return ES_ERR_OK;
}

static const char *makeAbsPath( const char *fileName )
{
    static std::string path;

    //#define NNT_ES_SIGLO_ROOT set by nact script or vcxporj to the root path of Siglo.
    const char* kResourcePath = "/Tests/Escore/Sources/Tests/Alpha/testEs_Alpha/";
    path = std::string(NNT_ES_SIGLO_ROOT) + std::string(kResourcePath) + fileName;

    return path.c_str();
}

static ESError __testTicket()
{
    ESError rv = ES_ERR_OK;
    ETicket et;

#if !defined( ES_TEST_MEMORY_CONSTRAINT )
    MemoryInputStream ticketReader( tkt2, sizeof( tkt2 ) );
#else
    FileStream ticketReader;
    if( !( ticketReader.TryInitialize( makeAbsPath("00000002.tik"), OPEN_MODE_READ ).IsSuccess() ) )
    {
        ES_TEST_LOG( "Failed to initialize ticket reader\n" );
        rv = ES_ERR_FAIL;
        goto end;
    }
#endif

#if !defined( ES_TEST_READ_ONLY )
    rv = et.Set( ticketReader, __certs, __nCerts, true );
#else
    rv = et.Set( ticketReader, __certs, __nCerts, false );
#endif
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set and verify eTicket, rv=%d\n", rv );
        goto end;
    }

end:
    return rv;
}  // NOLINT (readability/fn_size)

static ESError __testCleanup()
{
    return ES_ERR_OK;
}

/**
    @brief FS用アロケータ
 */
void* Allocate(size_t size)
{
    return std::malloc(size);
}

/**
    @brief FS用デアロケータ
 */
void Deallocate(void* p, size_t size)
{
    NN_UNUSED(size);
    std::free(p);
}

TEST( ReAlphaTest, Alpha )
{
    ESError rv = ES_ERR_OK;

    nn::fs::SetAllocator(Allocate, Deallocate);
    nn::fs::MountHostRoot();
    rv = __testSetup();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    rv = __testTicket();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    rv = __testCleanup();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

end:
    if( rv == ES_ERR_OK )
    {
        ES_TEST_LOG( "***** Passed alpha tests *****\n" );
    }

    return;
}
