﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nn/err/err_ReportMultimediaErrorApi.h>
#include <nn/err/err_Result.h>
#include <movie/private/MultimediaTelemetryReport.h>

using namespace nn;

TEST(ReportMultimediaError, Basic)
{
    movie::MultimediaTelemetryReport report;
    report.VideoCodecTypeEnum = 1;
    report.VideoBitRate = 2;
    report.VideoFrameRate = 3;
    report.VideoWidth = 4;
    report.VideoHeight = 5;
    report.AudioCodecTypeEnum = 6;
    report.AudioSampleRate = 7;
    report.AudioChannelCount = 8;
    report.AudioBitRate = 9;
    report.ContainerType = 10;
    report.ProfileType = 11;
    report.LevelType = 12;
    report.CacheSizeEnum = 13;
    report.ErrorStatusEnum = 14;
    for( size_t i = 0; i < sizeof(report.ErrorLog) / sizeof(report.ErrorLog[0]); i++ )
    {
        report.ErrorLog[i] = static_cast<uint8_t>(i);
    }
    // Result も適当なダミー。
    err::ReportMultimediaError(err::ResultApplicationAbort(), report);
}
