﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/err/err_ReportErrorApi.h>
#include <nn/err/err_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/util/util_StringUtil.h>
#include <nnt/nntest.h>

using namespace nn;

class ReportErrorTest : public testing::Test
{
public:
    static const nn::ApplicationId MyApplicationId;
protected:
    static void SetUpTestCase()
    {
        ns::Initialize();

    }
    static void TearDownTestCase()
    {
        ns::Finalize();
    }
};

const nn::ApplicationId ReportErrorTest::MyApplicationId = nn::ApplicationId{ 0x0100000000002101 };

TEST_F(ReportErrorTest, Result)
{
    err::ReportError(MyApplicationId, err::ResultApplicationAbort());
}

TEST_F(ReportErrorTest, ErrorCode)
{
    err::ErrorCode errorCode{ 2999, 9999 };
    err::ReportError(MyApplicationId, errorCode);
}

TEST_F(ReportErrorTest, ResultWithResultBacktrace)
{
    err::ResultBacktrace resultBacktrace;
    resultBacktrace.count = err::ResultBacktrace::CountMax;
    for( int i = 0; i < err::ResultBacktrace::CountMax; i++ )
    {
        resultBacktrace.results[i] = i % 2 == 0 ? static_cast<Result>(err::ResultApplicationAbort()) : static_cast<Result>(err::ResultSystemProgramAbort());
    }
    err::ReportError(MyApplicationId, err::ResultApplicationAbort(), resultBacktrace);
}

TEST_F(ReportErrorTest, ErrorCodeWithResultBacktrace)
{
    err::ResultBacktrace resultBacktrace;
    resultBacktrace.count = err::ResultBacktrace::CountMax;
    for( int i = 0; i < err::ResultBacktrace::CountMax; i++ )
    {
        resultBacktrace.results[i] = i % 2 == 0 ? static_cast<Result>(err::ResultApplicationAbort()) : static_cast<Result>(err::ResultSystemProgramAbort());
    }
    err::ErrorCode errorCode{ 2999, 9999 };
    err::ReportError(MyApplicationId, errorCode, resultBacktrace);
}

TEST_F(ReportErrorTest, ResultWithErrorContext)
{
    err::ErrorContext errorContext;
    errorContext.type = err::ErrorContextType::Http;
    util::Strlcpy(errorContext.http.fqdn, "fqdn", static_cast<int>(sizeof(errorContext.http.fqdn)));
    util::Strlcpy(errorContext.http.ip, "ip", static_cast<int>(sizeof(errorContext.http.ip)));
    Bit8 workBuffer[1024];
    err::ReportError(MyApplicationId, err::ResultApplicationAbort(), errorContext, workBuffer, sizeof(workBuffer));
}

TEST_F(ReportErrorTest, ErrorCodeWithErrorContext)
{
    err::ErrorContext errorContext;
    errorContext.type = err::ErrorContextType::Http;
    util::Strlcpy(errorContext.http.fqdn, "fqdn", static_cast<int>(sizeof(errorContext.http.fqdn)));
    util::Strlcpy(errorContext.http.ip, "ip", static_cast<int>(sizeof(errorContext.http.ip)));
    err::ErrorCode errorCode{ 2999, 9999 };
    Bit8 workBuffer[1024];
    err::ReportError(MyApplicationId, errorCode, errorContext, workBuffer, sizeof(workBuffer));
}
