﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEns_TaskSimulateServiceError.h"

#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/detail/util/ens_ResponseStructureReader.h>

namespace nnt { namespace ens {

TaskSimulateServiceError::TaskSimulateServiceError() NN_NOEXCEPT
    : m_StatusCode(0)
    , m_pCategory(nullptr)
    , m_pServerCode(nullptr)
{
}

TaskSimulateServiceError::~TaskSimulateServiceError() NN_NOEXCEPT
{
}

void TaskSimulateServiceError::SetParameter(int statusCode, const char* pCategory, const char* pServerCode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pCategory);
    NN_SDK_REQUIRES_NOT_NULL(pServerCode);

    m_StatusCode = statusCode;
    m_pCategory = pCategory;
    m_pServerCode = pServerCode;
}

nn::Result TaskSimulateServiceError::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(StepSimulate());

    NN_RESULT_SUCCESS;
}

nn::Result TaskSimulateServiceError::StepSimulate() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};

    // 入力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), nn::ens::ResultInvalidState());

        nn::ens::detail::core::MakeUrl(url, sizeof (url),
            "api", "/api/v1/error/simulate?status_code=%d&category=%s&server_code=%s",
            m_StatusCode, m_pCategory, m_pServerCode);
    }

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "GET"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));

    NN_RESULT_DO(Perform());

    NN_DETAIL_ENS_DUMP_RESPONSE(nn::ens::detail::util::MessagePackReader, GetResponse(), GetResponseSize());

    NN_RESULT_SUCCESS;
}

}}
