﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_Task.h>

namespace nnt { namespace ens {

/**
 * @brief   スレッド統計情報収集機能付きの一定時間待機するシンプルなタスク
 *
 * @details
 */
class TaskThreadStatistics : public nn::ens::detail::core::Task
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskThreadStatistics() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~TaskThreadStatistics() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   pTlsSlot    TLS スロット
     * @param[in]   span        待機期間
     *
     * @pre
     *  - pTls != nullptr
     *
     * @details
     */
    void SetParameter(nn::os::TlsSlot* pTlsSlot, nn::TimeSpan span) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::os::TlsSlot* m_pTlsSlot;
    //
    nn::TimeSpan m_Span;

private:
    //
    nn::Result StepWait() NN_NOEXCEPT;
};

}}
