﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEns_TaskLargeSize.h"

namespace nnt { namespace ens {

TaskLargeSize::TaskLargeSize() NN_NOEXCEPT
    : m_Span(0)
{
    NN_UNUSED(m_LargeBuffer);
}

TaskLargeSize::~TaskLargeSize() NN_NOEXCEPT
{
}

void TaskLargeSize::SetParameter(nn::TimeSpan span) NN_NOEXCEPT
{
    m_Span = span;
}

nn::Result TaskLargeSize::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(StepWait());

    NN_RESULT_SUCCESS;
}

nn::Result TaskLargeSize::StepWait() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!GetCancelEvent().TimedWait(m_Span), nn::ens::ResultCanceledByUser());

    NN_RESULT_SUCCESS;
}

}}
