﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../Common/testEns_Common.h"

#include <nn/ens/ens_SimpleMessagePackReader.h>

TEST(EnsSimpleMessagePackReader, Case1)
{
    nn::Bit8 data[] =
    {
        0x82,
        0xA7, 'c', 'o', 'm', 'p', 'a', 'c', 't', 0xC3,
        0xA6, 's', 'c', 'h', 'e', 'm', 'a', 0x00,
    };

    nn::ens::SimpleMessagePackReader reader(data, sizeof (data));

    EXPECT_TRUE(reader.IsValid());

    bool compact;
    EXPECT_TRUE(reader.Get(&compact, "$.compact"));
    EXPECT_EQ(compact, true);

    int schema;
    EXPECT_TRUE(reader.Get(&schema, "$.schema"));
    EXPECT_EQ(schema, 0);

    bool schema2;
    EXPECT_FALSE(reader.Get(&schema2, "$.schema"));
}

TEST(EnsSimpleMessagePackReader, Case2)
{
    nn::Bit8 data[] =
    {
        0x81,
        0xA2, 'k', '1',
        0x81,
        0xA2, 'k', '2',
        0x81,
        0xA2, 'k', '3',
        0x81,
        0xA2, 'k', '4',
        0x81,
        0xA2, 'k', '5',
        0x81,
        0xA2, 'k', '6',
        0x81,
        0xA2, 'k', '7',
        0x81,
        0xA2, 'k', '8',
        0x81,
        0xA2, 'k', '9',
        0x7F,
    };

    nn::ens::SimpleMessagePackReader reader(data, sizeof (data));

    EXPECT_TRUE(reader.IsValid());

    int value;
    EXPECT_TRUE(reader.Get(&value, "$.k1.k2.k3.k4.k5.k6.k7.k8.k9"));
    EXPECT_EQ(value, 127);

    EXPECT_FALSE(reader.Get(&value, "$"));
    EXPECT_FALSE(reader.Get(&value, "$.k1"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2.k3"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2.k3.k4"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2.k3.k4.k5"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2.k3.k4.k5.k6"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2.k3.k4.k5.k6.k7"));
    EXPECT_FALSE(reader.Get(&value, "$.k1.k2.k3.k4.k5.k6.k7.k8"));

    double value2;
    EXPECT_FALSE(reader.Get(&value2, "$.k1.k2.k3.k4.k5.k6.k7.k8.k9"));
}

TEST(EnsSimpleMessagePackReader, Case3)
{
    nn::Bit8 data[] =
    {
        0x64,
    };

    nn::ens::SimpleMessagePackReader reader(data, sizeof (data));

    EXPECT_TRUE(reader.IsValid());

    int value;
    EXPECT_TRUE(reader.Get(&value, "$"));
    EXPECT_EQ(value, 100);
}

TEST(EnsSimpleMessagePackReader, Case4)
{
    nn::Bit8 data[] =
    {
        0x93,
        0x01,
        0x02,
        0x03,
    };

    nn::ens::SimpleMessagePackReader reader(data, sizeof (data));

    EXPECT_TRUE(reader.IsValid());

    int values[3];
    EXPECT_TRUE(reader.Get(&values[0], "$[0]"));
    EXPECT_TRUE(reader.Get(&values[1], "$[1]"));
    EXPECT_TRUE(reader.Get(&values[2], "$[2]"));
    EXPECT_EQ(values[0], 1);
    EXPECT_EQ(values[1], 2);
    EXPECT_EQ(values[2], 3);
}

TEST(EnsSimpleMessagePackReader, Case5)
{
    nn::Bit8 data[] =
    {
        0x83,
        0xA4, 'k', 'e', 'y', '1', 0x64,
        0xA4, 'k', 'e', 'y', '2',
        0x82,
        0xA1, 'a', 0x64,
        0xA1, 'b', 0x64,
        0xA4, 'k', 'e', 'y', '3',
        0x93,
        0x01, 0x02, 0x03,
    };

    nn::ens::SimpleMessagePackReader reader(data, sizeof (data));

    struct
    {
        int key1;
        struct
        {
            int a;
            int b;
        }
        key2;
        int key3[3];
    }
    s;

    EXPECT_TRUE(reader.Get(&s.key1,    "$.key1"));
    EXPECT_TRUE(reader.Get(&s.key2.a,  "$.key2.a"));
    EXPECT_TRUE(reader.Get(&s.key2.b,  "$.key2.b"));
    EXPECT_TRUE(reader.Get(&s.key3[0], "$.key3[0]"));
    EXPECT_TRUE(reader.Get(&s.key3[1], "$.key3[1]"));
    EXPECT_TRUE(reader.Get(&s.key3[2], "$.key3[2]"));

    EXPECT_EQ(s.key1, 100);
    EXPECT_EQ(s.key2.a, 100);
    EXPECT_EQ(s.key2.b, 100);
    EXPECT_EQ(s.key3[0], 1);
    EXPECT_EQ(s.key3[1], 2);
    EXPECT_EQ(s.key3[2], 3);
}

TEST(EnsSimpleMessagePackReader, Case6)
{
    nn::Bit8 data[] =
    {
        0x82,
        0xA4, 'k', 'e', 'y', '1', 0x64,
        0xA4, 'k', 'e', 'y', '2',
        0x92,
        0x82,
        0xA1, 'a', 0x01,
        0xA1, 'b', 0x02,
        0x82,
        0xA1, 'a', 0x03,
        0xA1, 'b', 0x04,
    };

    nn::ens::SimpleMessagePackReader reader(data, sizeof (data));

    struct
    {
        int key1;
        struct
        {
            int a;
            int b;
        }
        key2[2];
    }
    s;

    EXPECT_TRUE(reader.Get(&s.key1,      "$.key1"));
    EXPECT_TRUE(reader.Get(&s.key2[0].a, "$.key2[0].a"));
    EXPECT_TRUE(reader.Get(&s.key2[0].b, "$.key2[0].b"));
    EXPECT_TRUE(reader.Get(&s.key2[1].a, "$.key2[1].a"));
    EXPECT_TRUE(reader.Get(&s.key2[1].b, "$.key2[1].b"));

    EXPECT_EQ(s.key1, 100);
    EXPECT_EQ(s.key2[0].a, 1);
    EXPECT_EQ(s.key2[0].b, 2);
    EXPECT_EQ(s.key2[1].a, 3);
    EXPECT_EQ(s.key2[1].b, 4);
}
