﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_HttpTask.h>
#include <nn/ens/ens_TypesForAcbaa.h>

namespace nnt { namespace ens {

/**
 * @brief   GetMessageMetadataFixture の非同期処理実装タスク
 *
 * @details
 */
class TaskGetMessageMetadataFixture : public nn::ens::detail::core::HttpTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskGetMessageMetadataFixture() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~TaskGetMessageMetadataFixture() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[out]  pOutMetadata    メタデータ
     *
     * @details
     */
    void SetParameter(nn::ens::ReceiveBuffer* pOutMetadata) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::ens::ReceiveBuffer* m_pOutMetadata;

private:
    //
    nn::Result StepGet() NN_NOEXCEPT;
};

}}
