﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEns_TaskGetMessageMetadataFixture.h"

#include <nn/ens/detail/core/ens_HttpRequestHeader.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>

namespace nnt { namespace ens {

TaskGetMessageMetadataFixture::TaskGetMessageMetadataFixture() NN_NOEXCEPT
    : m_pOutMetadata(nullptr)
{
}

TaskGetMessageMetadataFixture::~TaskGetMessageMetadataFixture() NN_NOEXCEPT
{
}

void TaskGetMessageMetadataFixture::SetParameter(nn::ens::ReceiveBuffer* pOutMetadata) NN_NOEXCEPT
{
    m_pOutMetadata = pOutMetadata;
}

nn::Result TaskGetMessageMetadataFixture::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(StepGet());

    NN_RESULT_SUCCESS;
}

nn::Result TaskGetMessageMetadataFixture::StepGet() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};
    nn::ens::detail::core::MakeUrl(url, sizeof (url), "api", "/api/v1/fixtures/message_cards");

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "GET"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));

    nn::ens::detail::core::HttpRequestHeader header;

    NN_RESULT_DO(header.Add("Content-Type", "application/x-msgpack"));

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, header.Get()));

    NN_RESULT_DO(Perform());

    NN_DETAIL_ENS_DUMP_RESPONSE(nn::ens::detail::util::MessagePackReader, GetResponse(), GetResponseSize());

    // 出力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        if (IsAsyncContextRegistered())
        {
            NN_RESULT_THROW_UNLESS(m_pOutMetadata->bufferSize >= GetResponseSize(), nn::ens::ResultInvalidResponse());

            std::memcpy(m_pOutMetadata->pBuffer, GetResponse(), GetResponseSize());
            m_pOutMetadata->receivedSize = GetResponseSize();
        }
    }

    NN_RESULT_SUCCESS;
}

}}
