﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <curl/curl.h>

namespace nnt { namespace ens {

/**
 * @brief   CURL ライブラリを初期化します。
 *
 * @param[in]   flags   curl_global_init に渡すフラグ
 *
 * @details
 *  メモリ使用量計測用の環境を構築します。
 */
void InitializeLibcurl(long flags = CURL_GLOBAL_DEFAULT) NN_NOEXCEPT;

/**
 * @brief   CURL ライブラリの終了処理を行います。
 *
 * @details
 */
void FinalizeLibcurl() NN_NOEXCEPT;

/**
 * @brief   ENS ライブラリが使用しないソケットを予約します。
 *
 * @details
 *  アプリケーションが使用できる 32 個のソケットの内、 31 個のソケットを予約します。
 */
void ReserveSockets() NN_NOEXCEPT;

/**
 * @brief   ソケットの予約を取り消します。
 *
 * @details
 */
void CancelSocketsReservation() NN_NOEXCEPT;

/**
 * @brief   通信ログのダンプを有効化します。
 *
 * @details
 */
void EnableCommunicationLogDump() NN_NOEXCEPT;

}}
