﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_EventTypes.h>
#include <hos/nvhdcp_up.h>

namespace nns {

class HdcpManager
{
private:
    HDCP_CLIENT_HANDLE m_Handle;
    bool m_IsNvhdcpAccessible;
    bool m_IsEnabled;
    bool m_IsTimeoutThreadRunning;
    bool m_IsAuthenticationTimeout;
    int m_AuthenticationTimeout;
    nn::os::ThreadType m_TimeoutThread;
    nn::os::EventType m_TimeoutEvent;
    typedef void(*StateTransitionHandler)(void* arg);
    uint32_t m_CurrentNvState;

public:
    typedef struct
    {
        StateTransitionHandler enabledStateHandler;
        StateTransitionHandler progressingStateHandler;
        StateTransitionHandler disabledStateHandler;
        StateTransitionHandler dockoutStateHandler;
        void* context;
    } StateTransitionType;
    StateTransitionType* pStateTransitionType;

    NN_IMPLICIT HdcpManager() NN_NOEXCEPT;
    ~HdcpManager() NN_NOEXCEPT;
    void SetHdcpListener(StateTransitionType* pType) NN_NOEXCEPT;
    bool SwitchHdcp(bool isEnabled) NN_NOEXCEPT;
    int GetAuthenticationTimeout() NN_NOEXCEPT;
    bool GetIsStubEmulation() NN_NOEXCEPT;
    void SetAuthenticationTimeout(int msec) NN_NOEXCEPT;
    void SetIsStubEmulation(bool isEnabled) NN_NOEXCEPT;
};

}
