﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/cec/cec_Types.h>

namespace nns {

class CecManager
{
private:
    bool m_IsInitialized;
    nn::os::ThreadType m_CecThread;
    nn::os::SystemEventType m_SystemEvent;
    nn::cec::BusEventType m_BusEventType;

    friend void CecCommandListener(void* arg);

public:
    NN_IMPLICIT CecManager() NN_NOEXCEPT;
    ~CecManager() NN_NOEXCEPT;
    bool SetCommandListener() NN_NOEXCEPT;
    bool SendOneTouchPlay() NN_NOEXCEPT;
    bool SendTvStandby() NN_NOEXCEPT;
    bool SendTvVolumeUp() NN_NOEXCEPT;
    bool SendTvVolumeDown() NN_NOEXCEPT;
    bool SendTvVolumeMute() NN_NOEXCEPT;
    nn::cec::BusEventType GetStoredBusEventType() NN_NOEXCEPT;
};

}
