﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <memory>

namespace nns {

class ProgramOptionParser
{
private:
    class ProgramOptionParserImpl;
    std::unique_ptr<ProgramOptionParserImpl> m_Impl;

public:
    NN_IMPLICIT ProgramOptionParser() NN_NOEXCEPT;
    ~ProgramOptionParser() NN_NOEXCEPT;

    void AddOption(const char shortName, const char* longName, bool isArgumentRequired, const char* helpMessage) NN_NOEXCEPT;
    bool ParseOption() NN_NOEXCEPT;
    bool GetBooleanOptionalValue(const char shortName, bool defaultValue) NN_NOEXCEPT;
    int GetIntegerOptionalValue(const char shortName, int defaultValue) NN_NOEXCEPT;
    float GetFloatOptionalValue(const char shortName, float defaultValue) NN_NOEXCEPT;
    const char* GetStringOptionalValue(const char shortName, const char* defaultValue) NN_NOEXCEPT;
    void ShowHelp() NN_NOEXCEPT;
};

}
