﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <vector>
#include <string>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

namespace nns {

class FilePathViewer
{
private:
    nn::Result m_SdCardOpenResult;
    nn::Result m_HostOpenResult;
    nn::Result m_RomOpenResult;
    size_t m_MountRomCacheBufferSize;
    void* m_MountRomCacheBuffer;

    bool SearchImageFile(std::vector<std::string>* pFileList, const char* directoryPath) NN_NOEXCEPT;
    const std::string ExtractExtension(const std::string& path);

public:
    NN_IMPLICIT FilePathViewer(const char* hostPath) NN_NOEXCEPT;
    ~FilePathViewer() NN_NOEXCEPT;
    void SearchImageFileFromAttachedDevice(std::vector<std::string>* pFileList) NN_NOEXCEPT;
};

}
