﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/vi/vi_DisplayModeInfoInternal.h>
#include "master/detail/visrv_WhitelistFilter.h"

TEST(WhiteListFilter, Width_Any)
{
    const int Height = 1080;
    const float RefreshRate = 60.f;
    const nn::vi::StereoMode Stereo = nn::vi::StereoMode_None;

    nn::vi::DisplayModeInfoInternal validMode{ { 1920, Height, RefreshRate, Stereo }, nn::vi::AspectRatio_16_9 };
    nn::vi::DisplayModeInfoInternal mode{ { 0, Height, RefreshRate, Stereo }, nn::vi::AspectRatio_16_9 };

    nn::visrv::master::detail::WhiteListFilter filter;
    filter.Initialize(&validMode, 1);
    EXPECT_FALSE(filter.IsValid(mode));
}

TEST(WhiteListFilter, Height_Any)
{
    const int Width = 1920;
    const float RefreshRate = 60.f;
    const nn::vi::StereoMode Stereo = nn::vi::StereoMode_None;

    nn::vi::DisplayModeInfoInternal validMode{ { Width, 1080, RefreshRate, Stereo }, nn::vi::AspectRatio_16_9 };
    nn::vi::DisplayModeInfoInternal mode{ { Width, 0, RefreshRate, Stereo }, nn::vi::AspectRatio_16_9 };

    nn::visrv::master::detail::WhiteListFilter filter;
    filter.Initialize(&validMode, 1);
    EXPECT_FALSE(filter.IsValid(mode));
}

TEST(WhiteListFilter, RefreshRate_Any)
{
    const int Width = 1920;
    const int Height = 1080;
    const nn::vi::StereoMode Stereo = nn::vi::StereoMode_None;

    nn::vi::DisplayModeInfoInternal validMode{ { Width, Height, 60.f, Stereo }, nn::vi::AspectRatio_16_9 };
    nn::vi::DisplayModeInfoInternal mode{ { Width, Height, 0.f, Stereo }, nn::vi::AspectRatio_16_9 };

    nn::visrv::master::detail::WhiteListFilter filter;
    filter.Initialize(&validMode, 1);
    EXPECT_FALSE(filter.IsValid(mode));
}

TEST(WhiteListFilter, StereoMode_Any)
{
    const int Width = 1920;
    const int Height = 1080;
    const float RefreshRate = 60.f;

    nn::vi::DisplayModeInfoInternal validMode{ { Width, Height, RefreshRate, nn::vi::StereoMode_None }, nn::vi::AspectRatio_16_9 };
    nn::vi::DisplayModeInfoInternal mode{ { Width, Height, RefreshRate, nn::vi::StereoMode_TopAndBottom }, nn::vi::AspectRatio_16_9 };

    nn::visrv::master::detail::WhiteListFilter filter;
    filter.Initialize(&validMode, 1);
    EXPECT_FALSE(filter.IsValid(mode));
}

TEST(WhiteListFilter, AspectRatio_Any)
{
    const int Width = 1920;
    const int Height = 1080;
    const float RefreshRate = 60.f;
    const nn::vi::StereoMode StereoMode = nn::vi::StereoMode_None;

    nn::vi::DisplayModeInfoInternal validMode{ { Width, Height, RefreshRate, StereoMode }, nn::vi::AspectRatio_16_9 };
    nn::vi::DisplayModeInfoInternal mode{ { Width, Height, RefreshRate, StereoMode }, nn::vi::AspectRatio_4_3 };

    nn::visrv::master::detail::WhiteListFilter filter;
    filter.Initialize(&validMode, 1);
    EXPECT_FALSE(filter.IsValid(mode));
}

TEST(WhiteListFilter, Valid_Any)
{
    nn::vi::DisplayModeInfoInternal mode{ { 1920, 1080, 60.f, nn::vi::StereoMode_None }, nn::vi::AspectRatio_16_9 };

    nn::visrv::master::detail::WhiteListFilter filter;
    filter.Initialize(&mode, 1);
    EXPECT_TRUE(filter.IsValid(mode));
}
