﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include "native/visrv_SurfaceComposerClientHolder.h"
#include "testDisplay_SupportFixture.h"

bool SupportFixture::g_isScalingModeSupported;
bool SupportFixture::g_hasQueriedScalingModeSupport;

SupportFixture::SupportFixture() NN_NOEXCEPT
{
    nn::visrv::native::InitializeSurfaceComposerClient();

    g_isScalingModeSupported = true;
    g_hasQueriedScalingModeSupport = false;
}

bool SupportFixture::ScalingModeSupport(nn::vi::ScalingMode mode) NN_NOEXCEPT
{
    g_hasQueriedScalingModeSupport = true;
    return g_isScalingModeSupported;
}

nn::visrv::master::detail::DisplaySupport SupportFixture::GetSupport() NN_NOEXCEPT
{
    nn::visrv::master::detail::DisplaySupport support = { ScalingModeSupport };

    return support;
}

bool SupportFixture::HasQueriedScalingModeSupport() NN_NOEXCEPT
{
    return g_hasQueriedScalingModeSupport;
}

void SupportFixture::SetScalingModeSupport(bool isSupported) NN_NOEXCEPT
{
    g_isScalingModeSupported = isSupported;
}
