﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include "master/detail/visrv_Policies.h"
#include "master/detail/visrv_PlatformDisplayDefines.h"
#include "master/detail/visrv_PlatformDisplayInfo.h"

// if we add more named Displays, then these tests will need to be updated
NN_STATIC_ASSERT(5 == nn::visrv::master::detail::PlatformDisplayCount);

TEST(Policies, Standard_Any)
{
    NN_ALIGNAS(NN_ALIGNOF(nn::visrv::master::detail::PlatformDisplayInfo)) char storage[sizeof(nn::visrv::master::detail::PlatformDisplayInfo) * nn::visrv::master::detail::PlatformDisplayCount];
    nn::visrv::master::detail::PlatformDisplayInfo* pDisplays = reinterpret_cast<nn::visrv::master::detail::PlatformDisplayInfo*>(storage);

    ASSERT_EQ(1, nn::visrv::master::detail::SetupStandardPolicy(pDisplays, nn::visrv::master::detail::PlatformDisplayCount));

    EXPECT_STREQ("Default", pDisplays->GetName());
    EXPECT_EQ(1920, pDisplays->GetLayerWidthPixelCountMax());
    EXPECT_EQ(1080, pDisplays->GetLayerHeightPixelCountMax());

    EXPECT_EQ(true, pDisplays->GetPolicy().HasLayerLimit());
    EXPECT_EQ(1, pDisplays->GetPolicy().GetLayerCountMax());
    EXPECT_EQ(0, pDisplays->GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(0, pDisplays->GetPolicy().GetZOrderCountMax());

    const nn::visrv::master::detail::DisplaySupport& support = pDisplays->GetSupport();

    EXPECT_FALSE(support.queryScalingModeSupport(nn::vi::ScalingMode_None));
    EXPECT_FALSE(support.queryScalingModeSupport(nn::vi::ScalingMode_Exact));
    EXPECT_TRUE(support.queryScalingModeSupport(nn::vi::ScalingMode_FitToLayer));
    EXPECT_FALSE(support.queryScalingModeSupport(nn::vi::ScalingMode_ScaleAndCrop));
    EXPECT_TRUE(support.queryScalingModeSupport(nn::vi::ScalingMode_PreserveAspectRatio));
}

TEST(Policies, Composition_Any)
{
    NN_ALIGNAS(NN_ALIGNOF(nn::visrv::master::detail::PlatformDisplayInfo)) char storage[sizeof(nn::visrv::master::detail::PlatformDisplayInfo) * nn::visrv::master::detail::PlatformDisplayCount];
    nn::visrv::master::detail::PlatformDisplayInfo* pDisplays = reinterpret_cast<nn::visrv::master::detail::PlatformDisplayInfo*>(storage);

    int displayCount = nn::visrv::master::detail::SetupCompositionPolicy(pDisplays, nn::visrv::master::detail::PlatformDisplayCount);
    ASSERT_EQ(5, displayCount);

    EXPECT_STREQ("Default", pDisplays->GetName());
    EXPECT_EQ(1920, pDisplays->GetLayerWidthPixelCountMax());
    EXPECT_EQ(1080, pDisplays->GetLayerHeightPixelCountMax());

    EXPECT_EQ(true, pDisplays->GetPolicy().HasLayerLimit());
    EXPECT_EQ(2, pDisplays->GetPolicy().GetLayerCountMax());
    EXPECT_EQ(0, pDisplays->GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(255, pDisplays->GetPolicy().GetZOrderCountMax());

    EXPECT_STREQ("External", pDisplays[1].GetName());
    EXPECT_EQ(1920, pDisplays[1].GetLayerWidthPixelCountMax());
    EXPECT_EQ(1080, pDisplays[1].GetLayerHeightPixelCountMax());

    EXPECT_EQ(true, pDisplays[1].GetPolicy().HasLayerLimit());
    EXPECT_EQ(0, pDisplays[1].GetPolicy().GetLayerCountMax());
    EXPECT_EQ(0, pDisplays[1].GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(0, pDisplays[1].GetPolicy().GetZOrderCountMax());

    EXPECT_STREQ("Edid", pDisplays[2].GetName());
    EXPECT_EQ(0, pDisplays[2].GetLayerWidthPixelCountMax());
    EXPECT_EQ(0, pDisplays[2].GetLayerHeightPixelCountMax());

    EXPECT_EQ(true, pDisplays[2].GetPolicy().HasLayerLimit());
    EXPECT_EQ(0, pDisplays[2].GetPolicy().GetLayerCountMax());
    EXPECT_EQ(0, pDisplays[2].GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(0, pDisplays[2].GetPolicy().GetZOrderCountMax());

    EXPECT_STREQ("Internal", pDisplays[3].GetName());
    EXPECT_EQ(1920, pDisplays[3].GetLayerWidthPixelCountMax());
    EXPECT_EQ(1080, pDisplays[3].GetLayerHeightPixelCountMax());

    EXPECT_EQ(true, pDisplays[3].GetPolicy().HasLayerLimit());
    EXPECT_EQ(0, pDisplays[3].GetPolicy().GetLayerCountMax());
    EXPECT_EQ(0, pDisplays[3].GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(0, pDisplays[3].GetPolicy().GetZOrderCountMax());

    EXPECT_STREQ("Null", pDisplays[4].GetName());
    EXPECT_EQ(0, pDisplays[4].GetLayerWidthPixelCountMax());
    EXPECT_EQ(0, pDisplays[4].GetLayerHeightPixelCountMax());

    EXPECT_EQ(true, pDisplays[4].GetPolicy().HasLayerLimit());
    EXPECT_EQ(0, pDisplays[4].GetPolicy().GetLayerCountMax());
    EXPECT_EQ(0, pDisplays[4].GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(0, pDisplays[4].GetPolicy().GetZOrderCountMax());

    for( int i = 0; i < displayCount; ++i )
    {
        EXPECT_FALSE(pDisplays[i].GetSupport().queryScalingModeSupport(nn::vi::ScalingMode_None));
        EXPECT_FALSE(pDisplays[i].GetSupport().queryScalingModeSupport(nn::vi::ScalingMode_Exact));
        EXPECT_TRUE(pDisplays[i].GetSupport().queryScalingModeSupport(nn::vi::ScalingMode_FitToLayer));
        EXPECT_FALSE(pDisplays[i].GetSupport().queryScalingModeSupport(nn::vi::ScalingMode_ScaleAndCrop));
        EXPECT_TRUE(pDisplays[i].GetSupport().queryScalingModeSupport(nn::vi::ScalingMode_PreserveAspectRatio));
    }
}
