﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include "master/detail/visrv_PlatformDisplayInfo.h"
#include "testDisplay_SupportFixture.h"

typedef SupportFixture PlatformDisplayInfo;

TEST_F(PlatformDisplayInfo, Ctor_Any)
{
    const char* name = "Test";

    nn::visrv::master::detail::DisplayPolicy policy(true, 1, 2, 3);
    nn::visrv::master::detail::DisplaySupport support = { nullptr };
    nn::visrv::master::detail::PlatformDisplayInfo info(name,
                                             1,
                                             2,
                                             policy,
                                             support,
                                             true);

    EXPECT_STREQ(name, info.GetName());
    EXPECT_EQ(1, info.GetLayerWidthPixelCountMax());
    EXPECT_EQ(2, info.GetLayerHeightPixelCountMax());
    EXPECT_EQ(true, info.GetPolicy().HasLayerLimit());
    EXPECT_EQ(1, info.GetPolicy().GetLayerCountMax());
    EXPECT_EQ(2, info.GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(3, info.GetPolicy().GetZOrderCountMax());
    EXPECT_EQ(nullptr, info.GetSupport().queryScalingModeSupport);
    EXPECT_TRUE(info.IsTouchscreen());
}

TEST_F(PlatformDisplayInfo, CopyCtor_Any)
{
    nn::visrv::master::detail::DisplayPolicy policy(true, 1, 2, 3);
    nn::visrv::master::detail::DisplaySupport support = { nullptr };
    nn::visrv::master::detail::PlatformDisplayInfo info("Test",
                                             1,
                                             2,
                                             policy,
                                             support,
                                             true);
    nn::visrv::master::detail::PlatformDisplayInfo copy(info);

    EXPECT_STREQ(info.GetName(), copy.GetName());
    EXPECT_EQ(info.GetLayerWidthPixelCountMax(), copy.GetLayerWidthPixelCountMax());
    EXPECT_EQ(info.GetLayerHeightPixelCountMax(), copy.GetLayerHeightPixelCountMax());
    EXPECT_EQ(info.GetPolicy().HasLayerLimit(), copy.GetPolicy().HasLayerLimit());
    EXPECT_EQ(info.GetPolicy().GetLayerCountMax(), copy.GetPolicy().GetLayerCountMax());
    EXPECT_EQ(info.GetPolicy().GetZOrderCountMin(), copy.GetPolicy().GetZOrderCountMin());
    EXPECT_EQ(info.GetPolicy().GetZOrderCountMax(), copy.GetPolicy().GetZOrderCountMax());
    EXPECT_EQ(info.GetSupport().queryScalingModeSupport, copy.GetSupport().queryScalingModeSupport);
    EXPECT_EQ(info.IsTouchscreen(), copy.IsTouchscreen());
}

TEST_F(PlatformDisplayInfo, ValidateLayerDimensions_Any)
{
    nn::visrv::master::detail::DisplayPolicy policy(false, 0, 0, 0);
    nn::visrv::master::detail::PlatformDisplayInfo info("",
                                             1,
                                             1,
                                             policy,
                                             nn::visrv::master::detail::DisplaySupport(),
                                             false);

    // layer size strictly less than max
    EXPECT_TRUE(info.ValidateLayerDimensions(0, 0));
    // layer size equal to max
    EXPECT_TRUE(info.ValidateLayerDimensions(1, 1));
    // layer size greater in x-direction
    EXPECT_FALSE(info.ValidateLayerDimensions(2, 1));
    // layer size greater in y-direction
    EXPECT_FALSE(info.ValidateLayerDimensions(1, 2));
    // negative width
    EXPECT_FALSE(info.ValidateLayerDimensions(-1, 0));
    // negative height
    EXPECT_FALSE(info.ValidateLayerDimensions(0, -1));
}

TEST_F(PlatformDisplayInfo, ValidateZOrder_Any)
{
    nn::visrv::master::detail::DisplayPolicy policy(false, 0, 0, 0);
    nn::visrv::master::detail::PlatformDisplayInfo info("",
                                             0,
                                             0,
                                             policy,
                                             nn::visrv::master::detail::DisplaySupport(),
                                             false);

    EXPECT_TRUE(info.ValidateZOrder(0));
    EXPECT_FALSE(info.ValidateZOrder(-1));
    EXPECT_FALSE(info.ValidateZOrder(1));
}

TEST_F(PlatformDisplayInfo, ValidateScalingMode_Any)
{
    nn::visrv::master::detail::PlatformDisplayInfo info("",
                                             0,
                                             0,
                                             nn::visrv::master::detail::DisplayPolicy(false,
                                                                           0,
                                                                           0,
                                                                           0),
                                             GetSupport(),
                                             false);

    // ensure call is getting routed to ScalingModeSupport
    info.ValidateScalingMode(nn::vi::ScalingMode_None);
    ASSERT_TRUE(HasQueriedScalingModeSupport());
}

TEST_F(PlatformDisplayInfo, WriteInfo_Any)
{
    nn::visrv::master::detail::DisplayPolicy policy(true, 1, 2, 3);
    nn::visrv::master::detail::PlatformDisplayInfo info("Test",
                                             4,
                                             5,
                                             policy,
                                             nn::visrv::master::detail::DisplaySupport(),
                                             false);

    nn::vi::DisplayInfo display;
    memset(&display, 0, sizeof(display));
    info.WriteInfo(&display);

    EXPECT_STREQ(info.GetName(), display.name);
    EXPECT_EQ(info.GetPolicy().HasLayerLimit(), display.hasLayerLimit);
    EXPECT_EQ(info.GetPolicy().GetLayerCountMax(), display.layerCountMax);
    EXPECT_EQ(info.GetLayerWidthPixelCountMax(), display.layerWidthPixelCountMax);
    EXPECT_EQ(info.GetLayerHeightPixelCountMax(), display.layerHeightPixelCountMax);
}
