﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testDisplay_LayerFixture.h"
#include "native/visrv_SurfaceComposerClientHolder.h"

namespace
{
    class InfoSet
    {
    public:
        InfoSet() NN_NOEXCEPT
        {
            m_Set.SetInfo(nn::vi::PolicyLevel_Standard,
                            nn::visrv::master::detail::PlatformDisplayInfo
                            (
                                "Test",
                                1920,
                                1080,
                                nn::visrv::master::detail::DisplayPolicy
                                (
                                    false,
                                    0,
                                    1,
                                    2
                                ),
                                nn::visrv::master::detail::DisplaySupport{ LayerFixture::IsScalingModeSupported },
                                false
                            ));
        }

        NN_IMPLICIT operator nn::visrv::master::detail::PlatformDisplayInfoSet() NN_NOEXCEPT
        {
            return m_Set;
        }
    private:
        nn::visrv::master::detail::PlatformDisplayInfoSet m_Set;
    };
}

bool LayerFixture::g_IsScalingModeSupported;

LayerFixture::LayerFixture() NN_NOEXCEPT
    : m_Display(InfoSet(),
                &m_Allocator,
                &m_Strategy)
    , m_Allocator(m_LayerSegment, sizeof(m_LayerSegment), NN_ALIGNOF(nn::visrv::master::Layer))
{
    g_IsScalingModeSupported = true;

    nn::visrv::native::InitializeSurfaceComposerClient();

    m_Lcd.Open();
    m_Hdmi.Open();
    m_Display.Open();

    m_Displays[0] = &m_Hdmi;
    m_Displays[1] = &m_Lcd;
    m_Strategy.Initialize(m_Displays, sizeof(m_Displays) / sizeof(m_Displays[0]));
}

LayerFixture::~LayerFixture() NN_NOEXCEPT
{
    m_Display.Close();
}

bool LayerFixture::IsScalingModeSupported(nn::vi::ScalingMode mode) NN_NOEXCEPT
{
    return g_IsScalingModeSupported;
}

nn::visrv::master::Display* LayerFixture::GetDisplay() NN_NOEXCEPT
{
    return &m_Display;
}

void LayerFixture::SetScalingModeSupport(bool isSupported) NN_NOEXCEPT
{
    g_IsScalingModeSupported = isSupported;
}
