﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include "master/detail/visrv_DisplayPolicy.h"

TEST(DisplayPolicy, Ctor_Any)
{
    nn::visrv::master::detail::DisplayPolicy policy(true,
                                         1,
                                         2,
                                         3);

    EXPECT_TRUE(policy.HasLayerLimit());
    EXPECT_EQ(1, policy.GetLayerCountMax());
    EXPECT_EQ(2, policy.GetZOrderCountMin());
    EXPECT_EQ(3, policy.GetZOrderCountMax());
}
