﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include "master/detail/visrv_PlatformDisplayInfo.h"
#include "master/detail/visrv_PoolAllocator.h"
#include "master/visrv_Display.h"

class DefaultDisplayFixture : public ::testing::Test
{
public:
    DefaultDisplayFixture() NN_NOEXCEPT;

    const nn::visrv::master::detail::PlatformDisplayInfoSet& GetInfoSet() const NN_NOEXCEPT;
    nn::visrv::master::Display::Allocator* GetAllocator() NN_NOEXCEPT;
private:
    nn::visrv::master::detail::PlatformDisplayInfoSet m_InfoSet;
    nn::visrv::master::Display::Allocator m_Allocator;
    char m_AllocationRegion[1024];
};
