﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Result.h>
#include "master/detail/visrv_DefaultDisplay-spec.NX.h"
#include "master/detail/visrv_DefaultDisplayStrategy.h"
#include "testDisplay_DefaultDisplayFixture.h"
#include "testDisplay_MockPhysicalDisplay.h"
#include "testDisplay_MockFilter.h"

typedef DefaultDisplayFixture DefaultDisplay;

TEST_F(DefaultDisplay, GetHotplugState_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    hdmi.SetHotplugState(nn::vi::HotplugState_Connected);

    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::HotplugStateType state;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetHotplugState(&state));

    display.Close();
}

TEST_F(DefaultDisplay, SetAlpha_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;

    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetAlpha(1.f));

    display.Close();
}

TEST_F(DefaultDisplay, SetPowerState_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;

    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetPowerState(nn::vi::PowerState_Off));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetPowerState(nn::vi::PowerState_On));

    display.Close();
}

TEST_F(DefaultDisplay, SetLayerStack_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;

    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Default));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Lcd));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Screenshot));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Recording));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_LastFrame));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Arbitrary));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetLayerStack(nn::vi::LayerStack_Null));

    display.Close();
}

TEST_F(DefaultDisplay, GetLayerStack_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;

    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::LayerStackType stack;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetLayerStack(&stack));

    display.Close();
}
TEST_F(DefaultDisplay, IsHotplugEventSupported_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;

    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    EXPECT_FALSE(display.IsHotplugEventSupported());

    display.Close();
}

TEST_F(DefaultDisplay, SetUnderscan_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetUnderscan(0));
}

TEST_F(DefaultDisplay, GetUnderscan_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    int underscan;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetUnderscan(&underscan));
}

TEST_F(DefaultDisplay, GetGamma_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float gamma;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.GetGamma(&gamma));
}

TEST_F(DefaultDisplay, SetGamma_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, display.SetGamma(1.f));
}

TEST_F(DefaultDisplay, SetCmuMode_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    nn::vi::CmuMode modes[] =
    {
        nn::vi::CmuMode_Disabled,
        nn::vi::CmuMode_Default,
        nn::vi::CmuMode_InvertColor,
        nn::vi::CmuMode_HighContrast,
        nn::vi::CmuMode_Grayscale
    };

    for( int i = 0; i < sizeof(modes) / sizeof(modes[0]); ++i )
    {
        NNT_EXPECT_RESULT_SUCCESS(display.SetCmuMode(modes[i]));

        nn::vi::CmuModeType current;
        NNT_EXPECT_RESULT_SUCCESS(lcd.GetCmuMode(&current));
        EXPECT_EQ(modes[i], current);

        NNT_EXPECT_RESULT_SUCCESS(hdmi.GetCmuMode(&current));
        EXPECT_EQ(modes[i], current);
    }
}

TEST_F(DefaultDisplay, SetContrastRatio_Any)
{
    MockPhysicalDisplay lcd;
    MockPhysicalDisplay hdmi;
    nn::visrv::master::detail::IPhysicalDisplay* displays[] =
    {
        &hdmi,
        &lcd,
    };
    nn::visrv::master::detail::DefaultDisplayStrategy strategy;
    strategy.Initialize(displays, sizeof(displays) / sizeof(displays[0]));

    nn::visrv::master::detail::DefaultDisplay display(GetInfoSet(), GetAllocator(), &strategy);
    NNT_ASSERT_RESULT_SUCCESS(display.Open());

    float ratios[] =
    {
        0.f,
        1.f
    };

    for( int i = 0; i < sizeof(ratios) / sizeof(ratios[0]); ++i )
    {
        NNT_EXPECT_RESULT_SUCCESS(display.SetContrastRatio(ratios[i]));

        float current;
        NNT_EXPECT_RESULT_SUCCESS(lcd.GetContrastRatio(&current));
        EXPECT_EQ(ratios[i], current);

        NNT_EXPECT_RESULT_SUCCESS(hdmi.GetContrastRatio(&current));
        EXPECT_EQ(ratios[i], current);
    }
}
