﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>
#include <nn/vi/vi_DisplayConfig.h>
#include <nn/vi/vi_DisplayEvents.h>
#include <nn/vi/vi_CmuLuma.h>
#include <nn/os/os_SystemEvent.h>

typedef nnt::vi::util::Fixture NullDisplay;

TEST_F(NullDisplay, GetDisplayHotplugState_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::vi::HotplugState state;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayHotplugState(&state, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, ListDisplayModes_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::vi::DisplayModeInfo modes[nn::vi::DisplayModeCountMax];
    EXPECT_EQ(0, nn::vi::ListDisplayModes(modes, nn::vi::DisplayModeCountMax, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayMode_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::vi::DisplayModeInfo mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultOperationFailed, nn::vi::GetDisplayMode(&mode, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayMode_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::vi::DisplayModeInfo mode;
    mode.width = 1920;
    mode.height = 1080;
    mode.refreshRate = 60.00f;
    mode.mode = nn::vi::StereoMode_None;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayMode(pDisplay, &mode));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, ListDisplayRgbRanges_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(ranges, nn::vi::RgbRange_Max, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayRgbRange_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::vi::RgbRange range;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultOperationFailed, nn::vi::GetDisplayRgbRange(&range, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayRgbRange_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayRgbRange(pDisplay, nn::vi::RgbRange_Full));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayUnderscan_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayUnderscan(pDisplay, 0));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayUnderscan_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    int underscan;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayUnderscan(&underscan, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayAlpha_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayAlpha(pDisplay, 1.f));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayPowerState_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayPowerState(pDisplay, nn::vi::PowerState_On));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayCmuLuma_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayCmuLuma(pDisplay, 0.f));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayCmuLuma_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    float luma;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayCmuLuma(&luma, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayHotplugEvent_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::os::SystemEventType event;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayHotplugEvent(&event, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayVsyncEvent_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::os::SystemEventType event;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayVsyncEvent(&event, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayLogicalResolution_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    int width;
    int height;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, SetDisplayLayerStack_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayLayerStack(pDisplay, nn::vi::LayerStack_Null));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(NullDisplay, GetDisplayModeChangedEvent_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Null"));

    nn::os::SystemEvent event;
    NNT_ASSERT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayModeChangedEvent(event.GetBase(), pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}
