﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/vi.private.h>

TEST(LayerSettings, GetLayerSettingsDefaults_Any)
{
    nn::vi::Initialize();

    nn::vi::LayerSettings settings;
    nn::vi::SetLayerSettingsDefaults(&settings);

    EXPECT_TRUE(settings.Test<nn::vi::LayerFlags::Fullscreen>());

    // testing that no other flags are set
    settings.Reset<nn::vi::LayerFlags::Fullscreen>();
    EXPECT_FALSE(settings.IsAnyOn());

    nn::vi::Finalize();
}
