<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Transition test

    .DESCRIPTION
        Verifies the HDMI works during a transition.  Calls the actual test internally.
#>

param
(
    [Parameter(Mandatory=$True)]
    [Int]
    # Number of iterations
    $Iterations,
    
    [Parameter(Mandatory=$False)]
    [String]
    # The artifact path
    $ArtifactPath,
    
    [Parameter(Mandatory=$True)]
    [String]
    # The ip address of the target
    $TargetAddress,
    
    [Parameter(Mandatory=$True)]
    [String]
    # The transition test to run
    $TransitionTest
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

. "${scriptDirectoryPath}\Common.ps1"
. "${scriptDirectoryPath}\${TransitionTest}"

Write-Host "Iterations: ${Iterations}"
$outputFile = "${scriptDirectoryPath}\out.png"
$startRes = 1080

Init-Transition-Test $scriptDirectoryPath $outputFile $TargetAddress

###############################################################################################
for($i = 0; $i -lt $Iterations; $i++)
{
    Write-Host "===Iteration $i ==="
    
    Transition-Loop "${i}" "${scriptDirectoryPath}" "${outputFile}" "${startRes}" "${TargetAddress}"
}

###############################################################################################

Cleanup-Transition-Test $scriptDirectoryPath

###############################################################################################
if ($failure)
{
    Write-Host "FAILURES OCCURRED"
    exit 1
}

Write-Host "Passed!"
exit 0
