<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        HDMI sleep-wake test (SDEV only)

    .DESCRIPTION
        Verifies the HDMI works properly following sleep-wake (must redock).
#>

. "${scriptDirectoryPath}\Common.ps1"

function Transition-Loop([string]$curIteration, [string]$scriptDirectoryPath, [string]$outputFile, [string]$resolution, [string]$targetAddress)
{
    Write-Host "Sleeping..."
    & $ControlTargetExe press-power-button

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${resolution}" "${curIteration}_" $LONG_WAIT

    Start-Sleep -s 10

    Write-Host "Waking..."
    & $ControlTargetPrivateExe press-power-button-for-sc7 --ip-addr $targetAddress

    & $ControlTargetExe connect

    & $ControlTargetExe enable-cradle

    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" --no-wait

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${resolution}_1" "${curIteration}a_" $LONG_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${resolution}_2" "${curIteration}b_" $SHORT_WAIT
}
