<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        HDMI dock-undock test for resolution switching(SDEV only)

    .DESCRIPTION
        Verifies the resolution is correct following dock-undock.
#>

. "${scriptDirectoryPath}\Common.ps1"


function Do-Transition([string]$scriptDirectoryPath, [string]$outputFile, [string]$transitionCounter, [int]$resolution, [string]$preResolution, [string]$postResolution, [string]$targetAddress)
{
    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" --no-wait -- -resolution ${resolution} -update_nand

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${preResolution}_1" "${transitionCounter}p_" $LONG_WAIT
    
    Write-Host "Undocking..."
    & $ControlTargetExe disable-cradle

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${preResolution}" "${transitionCounter}a_" $LONG_WAIT

    Write-Host "Docking..."
    & $ControlTargetExe enable-cradle
    
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${postResolution}_1" "${transitionCounter}b_" $LONG_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${postResolution}_2" "${transitionCounter}c_" $SHORT_WAIT
}
