﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>
#include <cstdio>

//#include "../../../../../Externals/Oasis/include/TMAPI.h"


int main(int argc, char **argv)
{
    const char* targetName = NULL;

    // Get the arguments
    for (int i = 1; i < argc; ++i)
    {

#define CHECK_ARG(name)                                     \
if (!_stricmp(argv[i], "-" #name))                          \
{                                                           \
        if (i + 1 >= argc)                                  \
        {                                                   \
            printf("Error: expected additional argument after -" #name "\n");   \
            return -1;                                      \
        }                                                   \
        ++i;                                                \
        name = argv[i];                                     \
        continue;                                           \
}

        CHECK_ARG(targetName);

#undef CHECK_ARG
    }

    if (!targetName)
    {
        printf("Usage:\n");
        printf("print_target_status.exe -targetName ### \n");
        printf("        Either enables or disables listening for the listed tones on the server\n");
        printf("    targetName: The IP address or name of the target\n");
        return -1;
    }

    printf("NOT SUPPORTED YET\n");

    //tmapi::power_state state;
    //tmapi::result result = GetTargetPowerState(handle, state);

    return -1;
}
