﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Tv.h>
#include <nvnflinger_service.h>
#include <nvdc.h>
#include <hos/nvdcutil.h>

namespace nns {

class VideoConfigHelper
{
private:
    static const int PathLength = 512;
    static bool m_IsShowingDisplayInfo;
    static char m_VirtualEdidDirectory[PathLength];
    bool m_IsVirtualEdidEnabled;
    int m_PreviousActiveDisplayId;

public:
    enum CeaAspectRatio {
        AspectRatio_4x3,
        AspectRatio_16x9,
        AspectRatio_64x27,
        AspectRatio_256x135,
        AspectRatio_NotCea,
        AspectRatio_Unknown,
    };

    NN_IMPLICIT VideoConfigHelper() NN_NOEXCEPT;
    ~VideoConfigHelper() NN_NOEXCEPT;
    bool IsExternalDisplayConnected() NN_NOEXCEPT;
    static void SetVirtualEdidDirectory(const char* path);
    bool SetVirtualEdid(const char* edidPath) NN_NOEXCEPT;
    bool ResetVirtualEdid() NN_NOEXCEPT;
    void ShowDisplayInfo() NN_NOEXCEPT;
    static void EnableShowingDisplayInfo(bool isEnabled) NN_NOEXCEPT;
    int GetActiveDisplayId() NN_NOEXCEPT;
    int GetDisplayInfoCount() NN_NOEXCEPT;
    int GetActiveDisplayWidth() NN_NOEXCEPT;
    int GetActiveDisplayHeight() NN_NOEXCEPT;
    float GetActiveDisplayFps() NN_NOEXCEPT;
    CeaAspectRatio GetActiveDisplayCeaAspectRatio() NN_NOEXCEPT;
    bool IsActiveDisplayCea() NN_NOEXCEPT;
    bool IsActiveDisplayDetailed() NN_NOEXCEPT;
    bool IsActiveDisplayHdmiExtension() NN_NOEXCEPT;
    bool SetMandatoryResolution() NN_NOEXCEPT;
    bool ResetPreviousResolution() NN_NOEXCEPT;
};

}
