﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <chrono>
#include <cstdio>
#include <cstdlib>
#include <thread>
#include <mutex>

#include "WorkerThreading.h"

void WorkerThreadFunc(WorkerThreading* parent);

WorkerThreading::WorkerThreading(int threads) : m_threadCount(threads), m_quit(false)
{
    m_threads.resize(m_threadCount);

    for (int i = 0; i < m_threadCount; ++i)
    {
        m_threads[i] = std::thread(WorkerThreadFunc, this);
    }
}

WorkerThreading::~WorkerThreading()
{
    m_quit = true;

    for (int i = 0; i < m_threadCount; ++i)
    {
        m_threads[i].join();
    }
}

void WorkerThreading::SetThreadCount(int threads)
{
    m_quit = true;

    for (int i = 0; i < m_threadCount; ++i)
    {
        m_threads[i].join();
    }

    m_quit = false;

    m_threadCount = threads;

    m_threads.resize(m_threadCount);

    for (int i = 0; i < m_threadCount; ++i)
    {
        m_threads[i] = std::thread(WorkerThreadFunc, this);
    }
}

void WorkerThreading::RunFunction(CallFunc func, void* pData)
{
    std::lock_guard<std::mutex> guard(m_mutex);

    m_queue.push(QueueData(func, pData));
}

// Thread that calls functions as needed
void WorkerThreadFunc(WorkerThreading* parent)
{
    WorkerThreading::QueueData data;

    while (!parent->m_quit)
    {
        std::this_thread::sleep_for(std::chrono::milliseconds(1));

        {
            std::lock_guard<std::mutex> guard(parent->m_mutex);

            if (parent->m_queue.empty())
            {
                continue;
            }

            data = parent->m_queue.front();
            parent->m_queue.pop();
        }

        data.func(data.pData);
    }
}
