﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <windows.h>
#include <cstdio>
#include <cstdlib>

#define ASSERT_SUCCEEDED(x)                                                         \
{                                                                                   \
    int hrFailure = 0;                                                              \
    if (!SUCCEEDED(hrFailure = (x)))                                                \
    {                                                                               \
        printf("Assertion on line %i failed (%i): %s\n", __LINE__, hrFailure, #x);  \
        exit(-1);                                                                   \
    }                                                                               \
}

// To keep track of the current time beyond milliseconds
struct Time
{
    Time()
    {
        LARGE_INTEGER li;
        ASSERT_SUCCEEDED(QueryPerformanceFrequency(&li));

        pcFreq = li.QuadPart / 1000000;
    }

    __int64 pcFreq;
} g_time;

__int64 GetTimeInMicroseconds()
{
    LARGE_INTEGER li;
    ASSERT_SUCCEEDED(QueryPerformanceCounter(&li));
    return li.QuadPart / g_time.pcFreq;
}
