﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <windows.h>

namespace BitmapHelper
{
    // Writes a bitmap file
    HRESULT Write(const char* pszFileName, BITMAPINFOHEADER *pBMI, unsigned long cbBMI, unsigned char *pData, unsigned long cbData);

    // Wrapper for WriteBitmap (24-bit)
    HRESULT Write24(const char* pFile, unsigned long width, unsigned long height, unsigned long size, unsigned char* pData);

    // Converts an 8 bit YUV bitmap into a 24-bit BGR bitmap
    void Convert8BitYUVToBGR(unsigned char* bytes, int width, int height, unsigned char** out, int* outSize);

    // Converts an 32-bit BGRA bitmap into a 24-bit BGR bitmap
    void ConvertBGRAToBGR(unsigned char* bytes, int width, int height, unsigned char** out, int* outSize);
}
