﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <windows.h>
#include <fstream>

namespace AudioWriter
{

// Writes out the header for the WAV file
HRESULT InitWAV(const char* fileName, HANDLE* pHandle, int dataSize, int bitRate, int numChannels, int sampleDepth)
{
    struct WAVHeader
    {
        DWORD               riff;
        unsigned long       riffSize;
        DWORD               wave;
        DWORD               fmt;
        unsigned long       wavSize;
        unsigned short      audioFormat;
        unsigned short      numChannels;
        unsigned long       sampleRate;
        unsigned long       bytesPerSec;
        unsigned short      blockAlign;
        unsigned short      sampleDepth;
        DWORD               data;
        unsigned long       dataSize;
    };

    HRESULT hr;
    *pHandle = CreateFileA(fileName, GENERIC_WRITE, 0, nullptr, CREATE_ALWAYS, 0, nullptr);

    if (*pHandle)
    {
        WAVHeader wavHeader;

        wavHeader.riff = 'FFIR';                // Big endian
        wavHeader.riffSize = sizeof(WAVHeader) + dataSize - sizeof(wavHeader.riff) - sizeof(wavHeader.riffSize);
        wavHeader.wave = 'EVAW';                // Big endian
        wavHeader.fmt = ' tmf';                 // Big endian
        wavHeader.wavSize = 16;
        wavHeader.audioFormat = 1;              // PCM
        wavHeader.numChannels = (unsigned short)numChannels;
        wavHeader.sampleRate = bitRate;
        wavHeader.bytesPerSec = bitRate * numChannels * (sampleDepth / 8);
        wavHeader.blockAlign = (unsigned short)(numChannels * (sampleDepth / 8));
        wavHeader.sampleDepth = (unsigned short)sampleDepth;
        wavHeader.data = 'atad';                // Big endian
        wavHeader.dataSize = dataSize;

        DWORD cbWritten = 0;
        BOOL result = WriteFile(*pHandle, &wavHeader, sizeof(wavHeader), &cbWritten, nullptr);

        hr = result ? S_OK : HRESULT_FROM_WIN32(GetLastError());
    }
    else
    {
        return HRESULT_FROM_WIN32(GetLastError());
    }

    return hr;
}

// Writes out a WAV file
HRESULT AppendWAV(HANDLE hFile, BYTE* pData, int dataSize)
{
    DWORD cbWritten = 0;
    BOOL result = WriteFile(hFile, pData, dataSize, &cbWritten, nullptr);

    return (result ? S_OK : HRESULT_FROM_WIN32(GetLastError()));
}

}
